<?php

declare(strict_types=1);

namespace Drupal\search_api_sqlite\Utility;

/**
 * Helper class for sanitizing field names to valid SQLite column names.
 */
final class ColumnNameHelper {

  /**
   * Sanitizes a field name for use as a SQLite column name.
   *
   * @param string $field_name
   *   The field name to sanitize.
   *
   * @return string
   *   The sanitized column name safe for use in SQLite.
   */
  public static function sanitize(string $field_name): string {
    // Replace special characters with underscores.
    $column = preg_replace('/[^a-zA-Z0-9_]/', '_', $field_name) ?? $field_name;

    // Ensure it doesn't start with a number.
    if ($column !== '' && is_numeric($column[0])) {
      return 'f_' . $column;
    }

    return $column;
  }

}
