<?php

declare(strict_types=1);

namespace Drupal\search_api_sqlite_test_autocomplete\Plugin\search_api_autocomplete\search;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\search_api_autocomplete\Attribute\SearchApiAutocompleteSearch;
use Drupal\search_api_autocomplete\Search\SearchPluginBase;
use Drupal\search_api_test\TestPluginTrait;

/**
 * Defines a test search for SQLite FTS5 autocomplete testing.
 */
#[SearchApiAutocompleteSearch(
  id: 'search_api_sqlite_test_autocomplete',
  label: new TranslatableMarkup('Autocomplete test module search'),
  description: new TranslatableMarkup('Test autocomplete search for SQLite FTS5'),
  group_label: new TranslatableMarkup('Test search'),
  group_description: new TranslatableMarkup('Searches used for tests'),
  index: 'sapi_sqlite_search_index',
)]
class TestSearch extends SearchPluginBase implements PluginFormInterface {

  use TestPluginTrait;

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore-next-line
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $this->logMethodCall(__FUNCTION__, func_get_args());
    if ($override = $this->getMethodOverride(__FUNCTION__)) {
      return call_user_func($override, $this, $form, $form_state);
    }

    return [];
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore-next-line
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $this->logMethodCall(__FUNCTION__, func_get_args());
    if ($override = $this->getMethodOverride(__FUNCTION__)) {
      call_user_func($override, $this, $form, $form_state);
    }
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore-next-line
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $this->logMethodCall(__FUNCTION__, func_get_args());
    if ($override = $this->getMethodOverride(__FUNCTION__)) {
      call_user_func($override, $this, $form, $form_state);
      return;
    }

    $this->setConfiguration($form_state->getValues());
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore-next-line
   */
  public function createQuery($keys, array $data = []) {
    $this->logMethodCall(__FUNCTION__, func_get_args());
    if ($override = $this->getMethodOverride(__FUNCTION__)) {
      return call_user_func($override, $this, $keys, $data);
    }

    return $this->search->getIndex()->query()->keys($keys);
  }

}
