<?php

declare(strict_types=1);

namespace Drupal\Tests\search_api_sqlite\Unit\EventSubscriber;

use Drupal\search_api_sqlite\Database\QueryLoggerInterface;
use Drupal\search_api_sqlite\EventSubscriber\QueryLogSubscriber;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\TerminateEvent;
use Symfony\Component\HttpKernel\HttpKernelInterface;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Tests the QueryLogSubscriber event subscriber.
 */
#[CoversClass(QueryLogSubscriber::class)]
#[Group('search_api_sqlite')]
class QueryLogSubscriberTest extends UnitTestCase {

  /**
   * Tests that the subscriber is registered for kernel.terminate.
   */
  public function testGetSubscribedEvents(): void {
    $events = QueryLogSubscriber::getSubscribedEvents();

    $this->assertArrayHasKey(KernelEvents::TERMINATE, $events);
    $this->assertSame(['onKernelTerminate', -100], $events[KernelEvents::TERMINATE]);
  }

  /**
   * Tests that onKernelTerminate flushes query logs.
   */
  public function testOnKernelTerminateFlushesLogs(): void {
    $queryLogger = $this->createMock(QueryLoggerInterface::class);
    $queryLogger->expects($this->once())
      ->method('flush')
      ->with(NULL);

    $subscriber = new QueryLogSubscriber($queryLogger);

    $kernel = $this->createMock(HttpKernelInterface::class);
    $request = new Request();
    $response = new Response();
    $event = new TerminateEvent($kernel, $request, $response);

    $subscriber->onKernelTerminate($event);
  }

}
