<?php

declare(strict_types=1);

namespace Drupal\search_api_sqlite\EventSubscriber;

use Drupal\search_api_sqlite\Database\QueryLoggerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\TerminateEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Flushes query logs at the end of each request.
 */
final readonly class QueryLogSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a QueryLogSubscriber instance.
   *
   * @param \Drupal\search_api_sqlite\Database\QueryLoggerInterface $queryLogger
   *   The query logger.
   */
  public function __construct(
    private QueryLoggerInterface $queryLogger,
  ) {}

  /**
   * Flushes all query logs on kernel terminate.
   *
   * @param \Symfony\Component\HttpKernel\Event\TerminateEvent $event
   *   The terminate event.
   */
  public function onKernelTerminate(TerminateEvent $event): void {
    // Flush logs for all indexes that have logging enabled.
    $this->queryLogger->flush();
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      KernelEvents::TERMINATE => ['onKernelTerminate', -100],
    ];
  }

}
