<?php

declare(strict_types=1);

namespace Drupal\search_api_sqlite\Event;

/**
 * Defines events for the Search API SQLite module.
 *
 * These events are specific to the SQLite FTS5 backend and complement
 * the core Search API events (SearchApiEvents).
 */
final class SearchApiSqliteEvents {

  /**
   * Event fired before building the FTS5 MATCH query.
   *
   * This allows modules to alter the MATCH query string that will be sent
   * to SQLite FTS5. Use this to customize search syntax, add boosting,
   * or modify the query structure.
   *
   * @Event
   *
   * @see \Drupal\search_api_sqlite\Event\MatchQueryAlterEvent
   */
  public const string MATCH_QUERY_ALTER = 'search_api_sqlite.match_query_alter';

  /**
   * Event fired before executing facet queries.
   *
   * This allows modules to alter facet configurations or add custom facets
   * before they are calculated against the search results.
   *
   * @Event
   *
   * @see \Drupal\search_api_sqlite\Event\FacetsPreExecuteEvent
   */
  public const string FACETS_PRE_EXECUTE = 'search_api_sqlite.facets_pre_execute';

}
