<?php

declare(strict_types=1);

namespace Drupal\search_api_sqlite\Utility;

/**
 * Static helper class for formatting values.
 */
final class FormatHelper {

  /**
   * Formats bytes to a human-readable string.
   *
   * @param int $bytes
   *   The number of bytes.
   * @param int $precision
   *   The number of decimal places.
   *
   * @return string
   *   The formatted string (e.g., "1.5 MB").
   */
  public static function formatBytes(int $bytes, int $precision = 2): string {
    if ($bytes === 0) {
      return '0 B';
    }

    $units = ['B', 'KB', 'MB', 'GB', 'TB'];
    $base = 1024;
    $exponent = (int) floor(log($bytes) / log($base));
    $exponent = min($exponent, count($units) - 1);

    $value = $bytes / ($base ** $exponent);

    return round($value, $precision) . ' ' . $units[$exponent];
  }

}
