# Search API SQLite FTS5

[![CI](https://git.drupalcode.org/project/search_api_sqlite/badges/1.0.x/pipeline.svg)](https://git.drupalcode.org/project/search_api_sqlite/-/pipelines)

A high-performance [Search API](https://www.drupal.org/project/search_api) backend for Drupal using SQLite FTS5 full-text search.

## Overview

This module provides a Search API backend that leverages SQLite's FTS5 extension for full-text search. It offers improved relevance ranking (BM25) and performance compared to the Database Search backend, without requiring external services like Solr or Elasticsearch.

**Suitable for:** Small to medium-sized sites with up to 500,000 searchable items.

## Requirements

- Drupal >= 10.3 | >= 11
- PHP 8.3+
- SQLite with FTS5 extension (included in most PHP distributions)
- Search API module

## Installation

Install via Composer:

```bash
composer require drupal/search_api_sqlite
```

Enable the module:

```bash
drush en search_api_sqlite
```

## Configuration

### Server Setup

1. Navigate to **Administration → Configuration → Search and metadata → Search API**
2. Click **Add server**
3. Select **SQLite FTS5** as the backend
4. Configure server options:
   - **Database path** — Location for SQLite files (default: `private://search_api_sqlite/`)
   - **Query logging** — Enable for debugging

> **Note:** Ensure your private file path is configured in `settings.php`.

### Index Configuration

Index-specific settings allow different search behaviors per index:

| Setting | Description |
|---------|-------------|
| **Tokenizer** | `unicode61` (default), `porter` (English stemming), `ascii`, or `trigram` (substring search) |
| **Case-sensitive** | For Trigram tokenizer only |
| **Min word length** | Ignore short search terms (not applicable to Trigram) |
| **Matching mode** | `words` (AND), `prefix`, `partial`, or `phrase` |
| **Auto-optimization** | Optimize index after N changes |

### Field Boost

Configure field boost values on your index fields to influence relevance ranking. Higher boost values increase a field's contribution to the BM25 score.

## Features

### Processors

#### SQLite FTS5 Highlighting

Uses native FTS5 `snippet()` function for search term highlighting.

**Configuration:**
- Highlight prefix/suffix (default: `<mark>`)
- Excerpt length (tokens)
- Exclude fields

#### SQLite Spell Check

Provides "Did you mean?" suggestions using external spell checkers.

**Requirements:**
```bash
composer require tigitz/php-spellchecker
```

Plus one of: `aspell`, `hunspell`, or PHP `pspell` extension with language dictionaries.

**Configuration:**
- Spell check backend
- Language code
- Result threshold (suggest when results < N)

**Views integration:** Use with [Search API Spellcheck](https://www.drupal.org/project/search_api_spellcheck) module.

### Supported Integrations

- [Facets](https://www.drupal.org/project/facets) — Full support including OR facets
- [Search API Autocomplete](https://www.drupal.org/project/search_api_autocomplete) — Prefix-based suggestions
- [Search API Spellcheck](https://www.drupal.org/project/search_api_spellcheck) — "Did you mean?" in Views

## Tokenizers

| Tokenizer | Use Case |
|-----------|----------|
| **Unicode61** | General purpose, diacritics removal (recommended) |
| **Porter** | English stemming (running → run) |
| **ASCII** | Simple English text |
| **Trigram** | Substring/partial matching, product codes, SKUs |

## Matching Modes

| Mode | Behavior |
|------|----------|
| **Words** | All terms must match (AND logic) |
| **Prefix** | Match word beginnings (`drupal*`) |
| **Partial** | Substring search (requires Trigram tokenizer) |
| **Phrase** | Exact phrase matching |

## Performance

- **Isolated indexes** — Each index uses its own SQLite file
- **WAL mode** — Concurrent reads without blocking
- **Memory-mapped I/O** — Efficient large index handling
- **Auto-optimization** — Configurable FTS5 optimization

## Drush Commands

| Command | Alias | Description |
|---------|-------|-------------|
| `search-api-sqlite:status [index]` | `sapi-sqlite-status` | Show index statistics (file size, item count, WAL status) |
| `search-api-sqlite:optimize [index]` | `sapi-sqlite-opt` | Merge b-tree segments for improved query performance |
| `search-api-sqlite:vacuum [index]` | `sapi-sqlite-vac` | Reclaim disk space and defragment database |
| `search-api-sqlite:check-integrity [index]` | `sapi-sqlite-check` | Validate FTS5 and database integrity |
| `search-api-sqlite:rebuild [index]` | `sapi-sqlite-rebuild` | Reconstruct FTS5 structures (no reindex needed) |
| `search-api-sqlite:recreate <index>` | `sapi-sqlite-recreate` | Delete and recreate database (destructive) |

All commands except `recreate` support `--all` to operate on all SQLite indexes.

## Contributing

Development uses [ddev-drupal-contrib](https://github.com/ddev/ddev-drupal-contrib).

```bash
# Clone and start
git clone https://git.drupalcode.org/project/search_api_sqlite.git
cd search_api_sqlite
ddev start

# Run checks
ddev phpcs        # Coding standards
ddev phpstan      # Static analysis
ddev phpunit      # Tests
```

### Running Tests

```bash
# Run all tests
ddev phpunit

# Run specific test suite
ddev phpunit --testsuite=unit

# Run specific test file
ddev phpunit path/to/TestFile.php
```

#### Parallel Test Execution (Optional)

To speed up test suite execution, use paratest:

```bash
# Copy paratest command to ddev commands folder (when using ddev)
cp .ddev-commands/web/paratest .ddev/commands/web

# Run tests in parallel
ddev paratest
```

### Issues

Submit issues and merge requests on the [GitLab project](https://git.drupalcode.org/project/search_api_sqlite).

## License

This project is licensed under the [GNU General Public License v2.0](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html).

## Links

- [Project page](https://www.drupal.org/project/search_api_sqlite)
- [Issue queue](https://www.drupal.org/project/issues/search_api_sqlite)
- [Source code](https://git.drupalcode.org/project/search_api_sqlite)
