<?php

declare(strict_types=1);

namespace Drupal\search_api_sqlite\Autocomplete;

use Drupal\search_api\Query\QueryInterface;
use Drupal\search_api_autocomplete\SearchInterface;

/**
 * Interface for the autocomplete handler service.
 *
 * This service handles generating autocomplete suggestions for search queries.
 */
interface AutocompleteHandlerInterface {

  /**
   * Gets autocomplete suggestions for a search query.
   *
   * @param \Drupal\search_api\Query\QueryInterface $query
   *   The search query.
   * @param \Drupal\search_api_autocomplete\SearchInterface $search
   *   The autocomplete search configuration.
   * @param string $incomplete_key
   *   The incomplete search key (last word being typed).
   * @param string $user_input
   *   The full user input string.
   * @param array<string, string> $fulltext_fields
   *   The fulltext field mapping (field_id => column_name).
   *
   * @return \Drupal\search_api_autocomplete\Suggestion\SuggestionInterface[]
   *   An array of autocomplete suggestions.
   */
  public function getSuggestions(
    QueryInterface $query,
    SearchInterface $search,
    string $incomplete_key,
    string $user_input,
    array $fulltext_fields,
  ): array;

}
