<?php

declare(strict_types=1);

namespace Drupal\Tests\search_api_sqlite\Unit\Status;

use Drupal\Core\File\FileSystemInterface;
use Drupal\search_api_sqlite\Database\Fts5QueryRunnerInterface;
use Drupal\search_api_sqlite\Database\SchemaManagerInterface;
use Drupal\search_api_sqlite\Database\ConnectionManagerInterface;
use Drupal\search_api_sqlite\Status\StatusReporter;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests the StatusReporter service.
 *
 * @group search_api_sqlite
 */
#[CoversClass(StatusReporter::class)]
#[Group('search_api_sqlite')]
class StatusReporterTest extends UnitTestCase {

  /**
   * Tests getSqliteVersionInfo() returns version information.
   *
   * This test doesn't require mocks since it creates its own PDO connection.
   */
  public function testGetSqliteVersionInfo(): void {
    // Create minimal mocks for constructor - they won't be used.
    $connectionManager = $this->createMock(ConnectionManagerInterface::class);
    $schemaManager = $this->createMock(SchemaManagerInterface::class);
    $fts5QueryRunner = $this->createMock(Fts5QueryRunnerInterface::class);
    $fileSystem = $this->createMock(FileSystemInterface::class);

    $statusReporter = new StatusReporter(
      $connectionManager,
      $schemaManager,
      $fts5QueryRunner,
      $fileSystem,
    );

    $version_info = $statusReporter->getSqliteVersionInfo();

    // Version should be a string like "3.45.0" or "Unknown".
    $this->assertMatchesRegularExpression('/^\d+\.\d+(\.\d+)?$|^Unknown$/', $version_info['version']);
    // FTS5 should be available in modern SQLite builds.
    $this->assertTrue($version_info['fts5_available']);
  }

}
