# Search API Term With Depth

This module brings Core's "Term with Depth" Views filter option to search_api-
based views.

After the module is installed, when you add a Views filter for a taxonomy
term field, you will see a select list of numbers and the following 
description:

The depth will match content tagged with terms in the hierarchy. 
For example, if you have the term "fruit" and a child term "apple", 
with a depth of 1 (or higher) then filtering for the term "fruit" 
will get content that are tagged with "apple" as well as "fruit". 
If negative, the reverse is true; searching for "apple" will also 
pick up content tagged with "fruit" if depth is -1 (or lower).

For a full description of the module, visit the
[project page](https://www.drupal.org/project/search_api_term_with_depth).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/search_api_term_with_depth)


## Table of contents (optional)

- Requirements
- Installation
- Configuration
- Maintainers


## Requirements

This module requires the following modules:

- [Search API](https://www.drupal.org/project/search_api)


## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Enable the module at Administration > Extend.
2. Clear caches.
3. Edit your search_api-based view and add a taxonomy term field.
4. Select your desired depth.


## Maintainers

- Daniel Cothran - [andileco](https://www.drupal.org/u/andileco)
