<?php

declare(strict_types=1);

namespace Drupal\search_api_typesense\Plugin\search_api\data_type;

use Drupal\search_api\DataType\DataTypePluginBase;

/**
 * Provides a Typesense float data type.
 *
 * @SearchApiDataType(
 *   id = "typesense_float",
 *   label = @Translation("Typesense: float"),
 *   description = @Translation("Floating point / decimal numbers"),
 *   fallback_type = "decimal"
 * )
 */
class FloatDataType extends DataTypePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getValue($value): float {
    return (float) $value;
  }

}
