<?php

declare(strict_types=1);

namespace Drupal\search_api_typesense\Plugin\search_api\data_type;

use Drupal\search_api\DataType\DataTypePluginBase;

/**
 * Provides a Typesense int32 data type.
 *
 * @SearchApiDataType(
 *   id = "typesense_int32",
 *   label = @Translation("Typesense: int32"),
 *   description = @Translation("Integer values up to 2,147,483,647"),
 *   fallback_type = "integer"
 * )
 */
class Int32DataType extends DataTypePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getValue($value): int {
    return (int) $value & 0xFFFFFFFF;
  }

}
