This module integrates Search API into <a href="https://www.vragen.ai/">Vragen.ai</a> for indexing of documents.

## Authentication
To enable this module to communicate with Vragen.ai's API it will need 2 things:
1. The correct endpoint created specifically for your organization.
2. The Bearer-token to authorize requests with.

This information can submit using the form found on: **/admin/config/search/vragen-ai**

## Configuration
1. Create new **Server**, with name "Vragen.ai"
2. Create new **Index**, adjust the following settings:
    - **Datasources**: "Content" and/or "Media" (It will attempt to index PDF documents through Media.)
    - **Bundles**: The bundles you like to index.
    - **Language**: What languages to include.
    - **Index items immediately**: "off"
    Note: You can leave this enabled, but it will start sending HTTP-requests to the backend immediately instead of handling this in your cron.
3. Configure and add all fields that are part of the index.
   _We advice to render to HTML so the backend is able to recognize semantics._
4. Configure additional metadata fields by setting the type of field to 'Vragen.ai Metadata'.
  _This metadata can be displayed in search results but will not be indexed, we recommend to use this for author / publication dates._