<?php

namespace Drupal\search_api_vragen_ai\Client;

use Swis\JsonApi\Client\Actions\FetchMany;
use Swis\JsonApi\Client\Actions\FetchOne;
use Swis\JsonApi\Client\BaseRepository as JsonApiBaseRepository;
use Swis\JsonApi\Client\Collection;

/**
 * Base repository class for Vragen.ai API repositories.
 *
 * @template TItem of \Swis\JsonApi\Client\Interfaces\ItemInterface
 */
abstract class BaseRepository extends JsonApiBaseRepository {
  /* @use \Swis\JsonApi\Client\Actions\FetchOne<TItem> */
  use FetchOne;
  /* @use \Swis\JsonApi\Client\Actions\FetchMany<TItem> */
  use FetchMany;

  public function __construct(Client $client) {
    parent::__construct($client->getDocumentClient(), $client->getDocumentFactory());
  }

  /**
   * Retrieve all items without pagination.
   *
   * @param array<string, mixed> $parameters
   *   Optional query parameters.
   * @param array<string, string> $headers
   *   Optional HTTP headers.
   */
  public function allWithoutPagination(array $parameters = [], array $headers = []): Collection {
    $pageParameters = ['size' => 50, 'number' => 1];
    $allItems = [];

    do {
      $document = $this->all([
        ...$parameters,
        'page' => $pageParameters,
      ], $headers);

      if ($document->hasErrors()) {
        throw new \RuntimeException('Error fetching data from vragen.ai: ' . json_encode($document->getErrors()));
      }

      foreach ($document->getData() as $item) {
        $allItems[] = $item;
      }

      $pageData = $document->getMeta()->page;
      if ($pageParameters['number'] >= $pageData->lastPage) {
        break;
      }

      $pageParameters['number']++;
    } while (TRUE);

    return Collection::make($allItems);
  }

}
