<?php

namespace Drupal\search_api_vragen_ai\EventSubscriber;

use Drupal\search_api\Event\MappingFieldTypesEvent;
use Drupal\search_api\Event\MappingViewsFieldHandlersEvent;
use Drupal\search_api\Event\MappingViewsHandlersEvent;
use Drupal\search_api\Event\SearchApiEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Adds field type mappers so we can filter on Vragen.ai Metadata in views.
 */
class MappingEventsSubscriber implements EventSubscriberInterface {

  /**
   * Maps vragen_ai_metadata to string.
   *
   * @param \Drupal\search_api\Event\MappingFieldTypesEvent $event
   *   The event.
   *
   * @return void
   *   Nothing.
   */
  public function onMappingFieldTypes(MappingFieldTypesEvent $event): void {
    $map = &$event->getFieldTypeMapping();

    $map['vragen_ai_metadata'] = 'string';
  }

  /**
   * Maps vragen_ai_metadata to search_api_text.
   *
   * @param \Drupal\search_api\Event\MappingViewsFieldHandlersEvent $event
   *   The event.
   *
   * @return void
   *   Nothing.
   */
  public function onMappingViewsFieldHandlers(MappingViewsFieldHandlersEvent $event): void {
    $mapping = &$event->getFieldHandlerMapping();

    $mapping['vragen_ai_metadata'] = $mapping['search_api_text'];
  }

  /**
   * Maps vragen_ai_metadata to string.
   *
   * @param \Drupal\search_api\Event\MappingViewsHandlersEvent $event
   *   The event.
   *
   * @return void
   *   Nothing.
   */
  public function onMappingViewsHandlers(MappingViewsHandlersEvent $event): void {
    $mapping = & $event->getHandlerMapping();

    $mapping['vragen_ai_metadata'] = $mapping['string'];
  }

  /**
   * Returns events to subscribe to.
   *
   * @return array|array[]|\array[][]|string[]
   *   Events that this EventSubscriber subscribed to.
   */
  public static function getSubscribedEvents(): array {
    // Workaround to avoid a fatal error during site install in some cases.
    // @see https://www.drupal.org/project/facets/issues/3199156
    if (!class_exists(SearchApiEvents::class, TRUE)) {
      return [];
    }
    return [
      SearchApiEvents::MAPPING_FIELD_TYPES => 'onMappingFieldTypes',
      SearchApiEvents::MAPPING_VIEWS_FIELD_HANDLERS => 'onMappingViewsFieldHandlers',
      SearchApiEvents::MAPPING_VIEWS_HANDLERS => 'onMappingViewsHandlers',
    ];
  }

}
