<?php

namespace Drupal\search_api_vragen_ai\Plugin\search_api\data_type;

use Drupal\search_api\DataType\DataTypePluginBase;

/**
 * Provides a vragen.ai metadata data type.
 *
 * @SearchApiDataType(
 *   id = "vragen_ai_metadata",
 *   label = @Translation("Vragen.ai metadata"),
 *   description = @Translation("Metadata type fields are passed to Vragen.ai as metadata."),
 *   default = "false",
 *   fallback_type = "string"
 * )
 */
class VragenAiMetaDataType extends DataTypePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getValue($value): string {
    return (string) $value;
  }

}
