# Search API Yext

This module provides a Search API backend to index content to Yext using the Yext Push API Connector system.

## Overview

The Search API Yext module allows you to automatically push your Drupal content to Yext's Knowledge Management system. This enables your content to be surfaced through Yext's search experiences and answers platforms.

## Prerequisites

- A Yext account with API access
- Search API module installed and enabled
- Content types configured for indexing

## Yext Setup

### 1. Create a Push API Connector

Before configuring this module, you'll need to create a Push API Connector in your Yext account:

1. Log into your Yext account
2. Follow the [Yext Hitchhikers documentation for creating a Push API Connector](https://hitchhikers.yext.com/docs/connectors/push-api-connector/)
3. Create your connector with a descriptive name - don't worry about field mappings yet
4. Note the connector name (you'll need this for the Drupal configuration)
5. Yext will automatically generate an API key for your connector - you can find this API key in the push connector's URL

### 2. Get Your Account Information

From your Yext account, you'll need:
- **Account ID**: Found in your account settings
- **API Key**: Automatically generated when you create the Push API Connector (visible in the connector's URL)
- **Connector Name**: The name you gave your Push API Connector

### 3. Create a Key in Drupal

Before configuring the Search API server, you need to securely store your Yext API key:

1. Go to **Configuration** → **System** → **Keys**
2. Click **Add key**
3. Configure the key:
   - **Key name**: Give it a descriptive name (e.g., "Yext API Key")
   - **Key type**: Select "Authentication"
   - **Key provider**: Choose your preferred provider (usually "Configuration" for development or "Environment" for production)
   - **Key value**: Enter your Yext API key
4. Click **Save**

## Drupal Configuration

### 1. Create a Search API Server

1. Go to **Configuration** → **Search and metadata** → **Search API**
2. Click **Add server**
3. Configure the server:
   - **Server name**: Give your server a descriptive name (e.g., "Yext Server")
   - **Backend**: Select "Yext"
   - **Account ID**: Enter your Yext account ID
   - **API Key**: Select the key you created in the previous step from the dropdown
   - **Disable truncation**: Optionally disable field truncation at 10,000 characters
4. Click **Save**

### 2. Create a Search API Index

1. From the Search API overview page, click **Add index**
2. Configure the index:
   - **Index name**: Give your index a descriptive name
   - **Data sources**: Select the content types you want to index to Yext
   - **Server**: Select your Yext server created above
3. Click **Save and add fields**

### 3. Configure Index Fields

1. Add the Drupal fields you want to send to Yext to your index
2. No field mapping is required at this stage - Yext will handle field mapping in the connector configuration
3. Save your field configuration

### 4. Configure Index Options

1. Go to your index's **Edit** page
2. At the bottom of the form, you'll find:
   - **Yext Connector Name**: Enter the exact name of your Push API Connector from Yext
3. Save the configuration

### 5. Initial Data Push

Before you can complete your Yext connector setup, you need to send sample data to Yext:

1. Go to **Configuration** → **Search and metadata** → **Search API**
2. Click on your index name
3. Enter "1" in the number of items field and click **Index now** to send just one item for testing
4. In Yext, edit your connector configuration and click the **Send request** tab on the left
5. Click the **Refresh** button to see the data that was sent by Drupal
6. Complete the field mapping configuration - make sure to map the "entityId" field from Drupal to the "Entity ID" field in Yext

## Usage

Once configured, the module will automatically:

- **Index content**: New and updated content will be pushed to Yext when saved
- **Delete content**: Deleted content will be removed from Yext
- **Bulk operations**: Use Search API's indexing tools to push existing content in bulk

### Manual Indexing

To manually trigger indexing:

1. Go to **Configuration** → **Search and metadata** → **Search API**
2. Click on your index name
3. Use the **Index now** button to queue content for indexing


## Best Practices

- Include standard Drupal fields (title, body, etc.) in your Search API index
- Use descriptive field names as these will be sent to Yext for field mapping
- All field mapping and data transformation is handled in the Yext connector configuration
- Test with a small subset of content before enabling for all content

## Troubleshooting

### Connection Issues

- Verify your Account ID and API Key are correct
- Ensure your API key has the necessary permissions
- Check that your Yext connector is active and properly configured

### Content Not Appearing

- Verify the connector name exactly matches what's configured in Yext
- Check that your field mappings are configured correctly in the Yext connector
- Review Search API indexing status and logs
- Ensure content is published and meets any configured filters

### Performance Considerations

- Use Search API's cron indexing for large content volumes
- Consider using Search API's batch deletion option for bulk operations
- Monitor your Yext API usage limits

## Support

For technical issues with this module, please check the project's issue queue. For Yext-specific questions, refer to the [Yext Hitchhikers documentation](https://hitchhikers.yext.com/) or contact Yext support.
