# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### Changed
- Internationalized all text strings to English for community distribution
- Made default configuration values more generic and universal
- Updated default GET parameter from 'search_api_fulltext' to 'search'
- Updated default allowed paths from '/buscador/*' to '/search/*'

## [1.0.0] - TBD

### Added
- Initial release of Search History module
- Search term tracking via browser localStorage
- Configurable settings form at `/admin/config/search/search-history`
- Search History block for displaying recent searches
- Path-based activation with wildcard support
- Configurable GET parameter name detection
- Maximum terms limit configuration
- Clear history functionality
- Client-side storage for privacy (no server-side data storage)
- Support for Drupal 9, 10, and 11
- Responsive CSS styling
- JavaScript behaviors for automatic term detection and storage
- Configuration schema for proper validation
- Menu integration in Search configuration section
- Permission system for administrative access

### Security
- All search terms stored client-side only
- No sensitive data transmitted to server
- XSS protection through proper Drupal rendering

### Performance
- Lightweight client-side implementation
- Minimal server-side processing
- Efficient localStorage management with automatic cleanup
- Conditional library loading based on path configuration
