# Search Tracker

A Drupal module that stores and displays search term history using localStorage.

## Features

- **Automatic storage**: Stores search terms automatically in browser's localStorage
- **Configurable parameters**: Set which URL parameter to monitor
- **Maximum terms limit**: Configure how many terms to keep in history
- **Path-based activation**: Choose which pages activate the module (supports wildcards)
- **Block display**: Shows recent searches as clickable links
- **Clear functionality**: Users can clear their search history
- **No database storage**: All data is stored client-side for privacy

## Installation

1. Download and extract the module to `modules/custom/search_tracker/`
2. Enable the module: `drush en search_tracker`
3. Configure permissions at `/admin/people/permissions`
4. Configure settings at `/admin/config/search/search-tracker`
5. Place the "Search Tracker" block in your desired region

## Configuration

Navigate to `/admin/config/search/search-tracker` to configure:

- **GET parameter name**: The URL parameter to monitor (default: 'search')
- **Maximum number of terms**: Maximum terms to store (default: 10)
- **Allowed paths**: Paths where the module activates (default: '/search', '/search/*')
- **localStorage key**: Key used for browser storage (default: 'search_tracker_terms')

### Path Configuration Examples

```
/search
/search/*
/node/*
/taxonomy/term/*
```

Wildcards (`*`) match any characters. One path per line.

## Usage

1. **Automatic tracking**: When users visit configured paths with the search parameter, terms are automatically stored
2. **Display block**: Place the "Search Tracker" block to show recent searches
3. **User interaction**: Users can click on previous searches or clear their history

## Requirements

- Drupal 9, 10, or 11
- Modern browser with localStorage support
- JavaScript enabled

## Permissions

- **Administer Search Tracker settings**: Allows access to configuration form

## Browser Compatibility

- Chrome 4+
- Firefox 3.5+
- Safari 4+
- Internet Explorer 8+
- Edge (all versions)

## Privacy

This module stores all data client-side in the user's browser. No search terms are stored on the server, ensuring user privacy.

## Development

### File Structure

```
search_tracker/
├── search_tracker.info.yml          # Module definition
├── search_tracker.module            # Hook implementations
├── search_tracker.routing.yml       # Routes definition
├── search_tracker.links.menu.yml    # Menu links
├── search_tracker.permissions.yml   # Permissions
├── search_tracker.libraries.yml     # CSS/JS libraries
├── config/schema/
│   └── search_tracker.schema.yml    # Configuration schema
├── src/
│   ├── Form/
│   │   └── SearchTrackerSettingsForm.php  # Settings form
│   └── Plugin/Block/
│       └── SearchTrackerBlock.php   # Block plugin
├── js/
│   └── search_tracker.js           # JavaScript functionality
└── css/
    └── search_tracker.css          # Basic styling
```

### JavaScript API

The module exposes search tracker functionality through Drupal behaviors:

```javascript
// Access current settings
const settings = drupalSettings.searchTracker;

// The module automatically:
// - Detects URL parameters
// - Stores/retrieves from localStorage
// - Renders history in blocks
// - Handles clear functionality
```

## Troubleshooting

### History not saving
- Check that JavaScript is enabled
- Verify localStorage is available and not full
- Ensure the page path matches configured allowed paths

### Block not showing
- Verify the block is placed in a visible region
- Check block visibility settings
- Ensure there are stored search terms

### Configuration not working
- Clear Drupal cache after configuration changes
- Verify user permissions
- Check browser console for JavaScript errors

## Contributing

See [CONTRIBUTING.md](CONTRIBUTING.md) for detailed instructions on contributing to this project.

## Changelog

See [CHANGELOG.md](CHANGELOG.md) for version history.

## License

This project is licensed under the GPL-2.0+ license - see the LICENSE file for details.

## Maintainers

Current maintainers:
- Javier Saenz de Navarrete - [\[WhereIAm\]](https://www.drupal.org/u/whereiam)

## Support

- **Issue queue**: Report bugs and request features on the [project page](https://www.drupal.org/project/search_tracker)
- **Documentation**: Additional documentation on the project page
- **Community**: Join discussions in the Drupal community
