<?php

namespace Drupal\search_tracker\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class SearchTrackerSettingsForm extends ConfigFormBase {

  protected function getEditableConfigNames() {
    return ['search_tracker.settings'];
  }

  public function getFormId() {
    return 'search_tracker_settings_form';
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('search_tracker.settings');

    $form['param_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('GET parameter name'),
      '#default_value' => $config->get('param_name') ?? 'search',
      '#required' => TRUE,
      '#description' => $this->t('Parameter that will be detected in the URL to store in the history.'),
    ];

    $form['max_items'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum number of terms to store'),
      '#default_value' => $config->get('max_items') ?? 10,
      '#min' => 1,
      '#description' => $this->t('Maximum number of elements in the history (not counting consecutive duplicates).'),
    ];

    $form['allowed_paths'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Allowed paths'),
      '#default_value' => $config->get('allowed_paths') ?? "/search\n/search/*",
      '#description' => $this->t('One per line. Wildcards with * are accepted. Compared against the internal path (e.g. /node/1).'),
    ];

    $form['storage_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('localStorage key'),
      '#default_value' => $config->get('storage_key') ?? 'search_tracker_terms',
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->configFactory->getEditable('search_tracker.settings')
      ->set('param_name', $form_state->getValue('param_name'))
      ->set('max_items', (int) $form_state->getValue('max_items'))
      ->set('allowed_paths', $form_state->getValue('allowed_paths'))
      ->set('storage_key', $form_state->getValue('storage_key'))
      ->save();
    parent::submitForm($form, $form_state);
  }
}
