<?php

namespace Drupal\search_tracker\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Render\Markup;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Provides a 'Search Tracker' Block.
 *
 * @Block(
 *  id = "search_tracker_block",
 *  admin_label = @Translation("Search Tracker"),
 * )
 */
class SearchTrackerBlock extends BlockBase implements ContainerFactoryPluginInterface {

  protected ConfigFactoryInterface $configFactory;

  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = new static($configuration, $plugin_id, $plugin_definition);
    $instance->configFactory = $container->get('config.factory');
    return $instance;
  }

  public function build() {
    $config = $this->configFactory->get('search_tracker.settings');

    $build = [
      '#type' => 'container',
      '#attributes' => [
        'class' => ['search-tracker-block'],
        'data-storage-key' => $config->get('storage_key') ?? 'search_tracker_terms',
      ],
      'list' => [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#attributes' => ['class' => ['search-tracker-list']],
      ],
      'clear_button' => [
        '#type' => 'html_tag',
        '#tag' => 'button',
        '#attributes' => [
          'type' => 'button',
          'class' => ['search-tracker-clear'],
        ],
        '#value' => $this->t('Clear history'),
      ],
      '#attached' => [
        'library' => [
          'search_tracker/search_tracker',
        ],
      ],
    ];

    return $build;
  }
}
