# Publishing to Drupal.org

This guide will help you publish the Searchify Connector module to the official Drupal.org repository.

## Prerequisites

1. **Drupal.org account**: You need an account on [Drupal.org](https://www.drupal.org)
2. **Git configuration**: Your Git must be configured with your Drupal.org username and email
3. **Project namespace**: You'll need to create a project on Drupal.org first

## Steps to Publish

### 1. Create Project on Drupal.org

1. Go to [Drupal.org](https://www.drupal.org) and log in
2. Navigate to [Create a new project](https://www.drupal.org/node/add/project-module)
3. Fill in the project details:
   - **Project name**: `searchify_connector`
   - **Short description**: "Connects to the Searchify API to perform search queries"
   - **Project type**: Full project
   - **Version control**: Git
4. Submit the form to create the project

### 2. Configure Git for Drupal.org

Based on your Drupal.org account settings, configure Git:

```bash
git config --global user.name 'Your Name'
git config --global user.email 'your-email@example.com'
```

Or use the anonymized email from your Drupal.org profile:
```bash
git config --global user.email 'YOUR-ID@users.noreply.drupalcode.org'
```

### 3. Initialize Git Repository (if not already done)

```bash
cd /Users/nikhiluppal/Downloads/searchify_connector
git init
```

### 4. Add Drupal.org Remote

After creating the project, Drupal.org will provide you with a Git URL. Add it as a remote:

```bash
git remote add origin git@git.drupalcode.org:project/searchify_connector.git
```

Or using HTTPS:
```bash
git remote add origin https://git.drupalcode.org/project/searchify_connector.git
```

### 5. Stage and Commit Files

Make sure you're in the module directory (not including the `web/` folder):

```bash
# Add all module files
git add .
git commit -m "Initial release of Searchify Connector module"
```

### 6. Push to Drupal.org

```bash
git push -u origin main
```

Or if using the default branch name:
```bash
git push -u origin master
```

### 7. Create Release on Drupal.org

1. Go to your project page on Drupal.org
2. Click "Create new release"
3. Fill in:
   - **Version**: `1.0.0` or `8.x-1.0` (depending on Drupal version)
   - **Release notes**: Describe the features and changes
4. Save the release

## Important Notes

### Security

✅ **All credentials have been removed from the codebase:**
- No hardcoded usernames or passwords
- Credentials are only stored in Drupal's configuration system
- Users must configure their own API credentials through the admin interface

### Files Included

The following files are ready for publishing:
- Module code (`src/`, `templates/`)
- Configuration files (`*.yml`, `composer.json`)
- Documentation (`README.md`)
- `.gitignore` and `.gitattributes` for proper version control

### Files Excluded

The following should NOT be committed (already in `.gitignore`):
- `web/` directory (Drupal core)
- `vendor/` directory (Composer dependencies)
- `.ddev/` directory (local development)
- OS files (`.DS_Store`, etc.)

## Testing Before Publishing

1. Test the module installation:
   ```bash
   drush en searchify_connector -y
   ```

2. Test the configuration form:
   - Navigate to `/admin/config/search/searchify`
   - Verify that no default credentials are shown
   - Test saving configuration with your own credentials

3. Test the search functionality:
   - Visit `/searchify`
   - Perform a test search
   - Verify results are displayed correctly

## After Publishing

Once published, users can install your module via:

```bash
composer require drupal/searchify_connector
```

Or download it from the Drupal.org project page.

## Maintenance

- Keep the codebase updated with security patches
- Respond to issues on the Drupal.org project page
- Update the module when Drupal core releases new versions
- Follow Drupal coding standards

## Resources

- [Drupal.org Git Documentation](https://www.drupal.org/docs/develop/git)
- [Drupal.org Project Application Guide](https://www.drupal.org/docs/develop/managing-a-drupalorg-theme-module-or-distribution-project)
- [Drupal Coding Standards](https://www.drupal.org/docs/develop/standards)

