# Searchify Connector

A Drupal module that connects your site to the Searchify API to perform search queries.

## Description

The Searchify Connector module provides a lightweight integration with the Searchify API, allowing site visitors to perform searches that are forwarded to your Searchify API endpoint. Results are rendered using a customizable Twig template.

## Features

- Secure API credential management (stored in Drupal configuration)
- Configurable API endpoint URL
- Public-facing search form
- Customizable results template
- Error logging and handling

## Requirements

- Drupal 10 or 11
- PHP 8.1 or higher
- Valid Searchify API credentials

## Installation

1. Download and install the module using Composer:
   ```bash
   composer require drupal/searchifyai
   ```
   
   Or download from [Drupal.org](https://www.drupal.org/project/searchifyai) and place in your `modules` directory.

2. Enable the module:
   ```bash
   drush en searchify_connector -y
   ```
   
   Or navigate to **Extend** (`/admin/modules`) and enable "Searchify Connector".

3. Clear the cache:
   ```bash
   drush cr
   ```

## Configuration

1. Navigate to **Configuration > Search > Searchify API Settings** (`/admin/config/search/searchify`).

2. Enter your Searchify API credentials:
   - **API Base URL**: Your Searchify API endpoint (e.g., `https://example.com/v1/stream`)
   - **API Username**: Your Searchify API username
   - **API Password**: Your Searchify API password

3. Click **Save configuration**.

**Note**: All credentials are stored securely in your Drupal site's configuration and are never exposed in the codebase.

## Usage

Once configured, visitors can access the search page at `/searchify` and perform searches. The module will:

1. Forward the search query to your configured Searchify API endpoint
2. Display results using the `searchify-results.html.twig` template
3. Log any API errors to Drupal's watchdog/logging system

## Customization

### Results Template

You can customize the search results display by overriding the `searchify-results.html.twig` template in your theme.

### Permissions

- **Access content**: Required to view the search page
- **Administer site configuration**: Required to configure API settings

## Troubleshooting

- **No results displayed**: Check that your API credentials are correct and the API endpoint is accessible.
- **API errors**: Check Drupal's log messages at **Reports > Recent log messages** (`/admin/reports/dblog`).
- **Configuration issues**: Ensure all three fields (Base URL, Username, Password) are filled in the configuration form.

## Security

- API credentials are stored in Drupal's configuration system and are encrypted at rest if your site uses configuration encryption.
- Credentials are never exposed in the codebase or version control.
- The password field in the configuration form only updates when a new password is entered.

## Support

For issues, feature requests, or contributions, please visit the [project page on Drupal.org](https://www.drupal.org/project/searchifyai).

## License

GPL-2.0-or-later
