# Local Testing Guide for Searchify Connector

## Quick Start - Test Your Module Locally

### Option 1: Using DDEV (Recommended if you have DDEV)

1. **Navigate to your Drupal site directory** (where your `composer.json` is for the Drupal site)

2. **Install the module via Composer:**
   ```bash
   composer require drupal/searchifyai:dev-main
   ```
   
   Or if you want to test from your local directory:
   ```bash
   composer require drupal/searchifyai:dev-main --prefer-source
   ```

3. **Enable the module:**
   ```bash
   drush en searchify_connector -y
   ```

4. **Clear cache:**
   ```bash
   drush cr
   ```

5. **Access the module:**
   - **Search page**: `http://your-site.local/searchify`
   - **Configuration**: `http://your-site.local/admin/config/search/searchify`

### Option 2: Direct Git Clone (For Development)

1. **Clone your module into the modules directory:**
   ```bash
   cd /path/to/your/drupal/site/web/modules/custom
   git clone https://git.drupalcode.org/project/searchifyai.git searchify_connector
   ```

2. **Enable the module:**
   ```bash
   drush en searchify_connector -y
   ```

3. **Clear cache:**
   ```bash
   drush cr
   ```

4. **Access the module:**
   - **Search page**: `http://your-site.local/searchify`
   - **Configuration**: `http://your-site.local/admin/config/search/searchify`

### Option 3: Composer Path Repository (Best for Active Development)

1. **Add to your Drupal site's `composer.json`:**
   ```json
   {
     "repositories": [
       {
         "type": "path",
         "url": "/Users/nikhiluppal/Downloads/searchify_connector"
       }
     ]
   }
   ```

2. **Require the module:**
   ```bash
   composer require drupal/searchifyai:@dev
   ```

3. **Enable and test:**
   ```bash
   drush en searchify_connector -y
   drush cr
   ```

## Testing Checklist

1. **Configure API Settings:**
   - Go to `/admin/config/search/searchify`
   - Enter your API Base URL
   - Enter your API Username
   - Enter your API Password
   - Save configuration

2. **Test Search Functionality:**
   - Visit `/searchify`
   - Enter a search query
   - Submit and verify results display

3. **Check Logs:**
   - Go to `/admin/reports/dblog`
   - Look for any errors related to `searchify_connector`

## Quick Test URLs

Once your module is enabled, you can use these URLs:

- **Search Page**: `http://localhost/searchify` (or your local domain)
- **Configuration**: `http://localhost/admin/config/search/searchify`
- **Logs**: `http://localhost/admin/reports/dblog`

## Troubleshooting

- **Module not found**: Make sure you've run `composer require` or cloned the module correctly
- **Route not found**: Clear cache with `drush cr`
- **Configuration not saving**: Check file permissions and ensure you have admin access
- **API errors**: Check the logs at `/admin/reports/dblog` for detailed error messages


