/**
 * @file
 * JavaScript for Searchify Connector search results.
 */

(function (Drupal) {
  'use strict';

  /**
   * Process citation links in the response text.
   */
  Drupal.behaviors.searchifyCitations = {
    attach: function (context, settings) {
      const responseText = document.querySelector('.searchify-text');
      if (!responseText) {
        return;
      }

      // Find all citation markers like [0], [1], [2], etc.
      const citationRegex = /\[(\d+)\]/g;
      let match;
      let html = responseText.innerHTML;

      // Replace citation markers with clickable links
      html = html.replace(citationRegex, function(match, citationId) {
        const citationLink = '<a href="#citation-' + citationId + '" class="citation-link" title="Jump to source ' + citationId + '">[' + citationId + ']</a>';
        return citationLink;
      });

      responseText.innerHTML = html;
    }
  };

})(Drupal);

