<?php

namespace Drupal\searchify_connector\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class SearchifySearchForm extends FormBase {

  public function getFormId() {
    return 'searchify_search_form';
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['query'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Search'),
      '#placeholder' => $this->t('Ask a question...'),
      '#required' => TRUE,
      '#default_value' => $this->getRequest()->query->get('q'),
    ];

    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Search'),
    ];

    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $query = $form_state->getValue('query');
    $form_state->setRedirect('searchify_connector.search_page', [], ['query' => ['q' => $query]]);
  }
}