# Troubleshooting Guide

## 404 Error on Configuration Page

If you're getting a 404 error when accessing `/admin/config/search/searchify`, try these steps:

### Step 1: Verify Module is Enabled

**Via Web UI:**
1. Go to: http://localhost:8888/admin/modules
2. Search for "Searchify Connector"
3. Check the box and click "Install"
4. Clear cache: http://localhost:8888/admin/config/development/performance

**Via Drush (if available):**
```bash
cd web
./vendor/bin/drush pm:list --status=enabled --type=module | grep searchify
```

If not enabled:
```bash
cd web
./vendor/bin/drush en searchify_connector -y
./vendor/bin/drush cr
```

### Step 2: Clear All Caches

**Via Web UI:**
1. Go to: http://localhost:8888/admin/config/development/performance
2. Click "Clear all caches"

**Via Drush:**
```bash
cd web
./vendor/bin/drush cr
```

**Manual (delete cache directories):**
```bash
cd web
rm -rf sites/default/files/php
rm -rf sites/default/files/css
rm -rf sites/default/files/js
```

### Step 3: Verify Module Location

Check that the module is in the correct location:
```bash
ls -la web/modules/custom/searchify_connector/
```

You should see:
- `searchify_connector.info.yml`
- `searchify_connector.module`
- `searchify_connector.routing.yml`
- `src/` directory

### Step 4: Check Route Registration

Verify the routing file exists and is correct:
```bash
cat web/modules/custom/searchify_connector/searchify_connector.routing.yml
```

Should contain:
```yaml
searchify_connector.settings:
  path: '/admin/config/search/searchify'
  defaults:
    _form: '\Drupal\searchify_connector\Form\SearchifyConfigForm'
    _title: 'Searchify API Settings'
  requirements:
    _permission: 'administer site configuration'
```

### Step 5: Check Permissions

Make sure you're logged in as an administrator with the "Administer site configuration" permission.

### Step 6: Check Error Logs

1. Go to: http://localhost:8888/admin/reports/dblog
2. Look for any errors related to "searchify_connector" or "routing"

### Step 7: Rebuild Router

If routes still don't work, rebuild the router:

**Via Drush:**
```bash
cd web
./vendor/bin/drush router-rebuild
```

**Or manually:**
1. Go to: http://localhost:8888/admin/config/development/performance
2. Click "Clear all caches" multiple times
3. Or uninstall and reinstall the module

### Step 8: Verify PHP and Drupal Requirements

Check that you meet the requirements:
- PHP 8.1 or higher: `php -v`
- Drupal 10 or 11 installed

### Step 9: Check File Permissions

Ensure files are readable:
```bash
chmod -R 755 web/modules/custom/searchify_connector
```

## Common Issues

### "Module not found"
- The module isn't in `web/modules/custom/searchify_connector/`
- Run the setup script: `./setup-local.sh`

### "Class not found"
- Autoloader needs to be regenerated
- Run: `cd web && composer dump-autoload`

### "Route not found"
- Cache needs clearing
- Module needs to be enabled
- Routing file might be missing

### "Permission denied"
- You need "Administer site configuration" permission
- Log in as user 1 (admin) or grant the permission

## Still Not Working?

1. Check Drupal's status report: http://localhost:8888/admin/reports/status
2. Enable error reporting in `web/sites/default/settings.php`:
   ```php
   $config['system.logging']['error_level'] = 'verbose';
   ```
3. Check PHP error logs
4. Try accessing the route directly: http://localhost:8888/searchify (this should work if module is enabled)




