<?php

namespace Drupal\searchify_connector\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\searchify_connector\Service\SearchifyApiService;
use Drupal\Core\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\RequestStack;

class SearchifyController extends ControllerBase {

  protected $searchifyApi;
  protected $formBuilder;
  protected $requestStack;

  public function __construct(SearchifyApiService $searchify_api, FormBuilderInterface $form_builder, RequestStack $request_stack) {
    $this->searchifyApi = $searchify_api;
    $this->formBuilder = $form_builder;
    $this->requestStack = $request_stack;
  }

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('searchify_connector.api'),
      $container->get('form_builder'),
      $container->get('request_stack')
    );
  }

  public function content() {
    $build['search_form'] = $this->formBuilder->getForm('Drupal\searchify_connector\Form\SearchifySearchForm');
    // Add wrapper attributes to ensure proper CSS targeting
    $build['search_form']['#attributes']['class'][] = 'searchify-search-form-wrapper';
    
    $query = $this->requestStack->getCurrentRequest()->query->get('q');
    $results = [];

    if (!empty($query)) {
      $results = $this->searchifyApi->performSearch($query);
    }

    // Get display settings from configuration
    $config = $this->config('searchify_connector.settings');
    $display_settings = [
      'metadata_fields' => $config->get('metadata_fields') ?: ['all'],
    ];

    $build['results'] = [
      '#theme' => 'searchify_results',
      '#results' => $results,
      '#query' => $query,
      '#display_settings' => $display_settings,
    ];

    // Add CSS for citation links and styling
    $build['#attached']['library'][] = 'searchify_connector/searchify_results';

    return $build;
  }
}