<?php

namespace Drupal\secret_login\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Alters existing routes to make them dynamic.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    $config = \Drupal::config('secret_login.settings');
    $custom_path = $config->get('custom_path');

    if (!empty($custom_path) && $collection->get('secret_login.user')) {
      // Update the path for the route dynamically.
      $route = $collection->get('secret_login.user');
      $route->setPath($custom_path);
    }
  }

}
