<?php

namespace Drupal\secret_login\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a configuration form for the Secret Login module.
 */
class CustomRouteConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   *
   * Returns the configuration names that are editable.
   */
  protected function getEditableConfigNames() {
    return ['secret_login.settings'];
  }

  /**
   * {@inheritdoc}
   *
   * Returns the form ID.
   */
  public function getFormId() {
    return 'secret_login_route_config_form';
  }

  /**
   * {@inheritdoc}
   *
   * Builds the configuration form.
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('secret_login.settings');
    $form['custom_path'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Login URL'),
      '#description' => $this->t('Enter the custom path for the login URL endpoint.'),
      '#default_value' => $config->get('custom_path') ?: '/',
    ];
    $form['actions'] = [
      '#type' => 'actions',
    ];
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Save'),
      '#button_type' => 'primary',
    ];
    // Reset button.
    $form['actions']['reset'] = [
      '#type' => 'submit',
      '#value' => $this->t('Reset'),
      '#submit' => ['::resetForm'],
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   *
   * Handles form submission for saving the custom path.
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('secret_login.settings')
      ->set('custom_path', $form_state->getValue('custom_path'))
      ->save();
    parent::submitForm($form, $form_state);
  }

  /**
   * Custom reset handler.
   *
   * Resets the login URL to its default value.
   */
  public function resetForm(array &$form, FormStateInterface $form_state) {
    $this->config('secret_login.settings')
      ->set('custom_path', '/')
      ->save();
    $this->messenger()->addMessage($this->t('The Secret Login URL has been reset to the default value.'));
    $form_state->setRedirect('secret_login.settings_form');
  }

}
