<?php

namespace Drupal\sector_view\Plugin\views\style;

use Drupal\views\Plugin\views\style\HtmlList;

/**
 * Custom HTML list format plugin.
 *
 * @ingroup views_style_plugins
 *
 * @ViewsStyle(
 *   id = "sector_listing",
 *   title = @Translation("Sector › Listing"),
 *   help = @Translation("Displays rows in a custom HTML list format."),
 *   theme = "views_view_sector_listing",
 *   display_types = {"normal"}
 * )
 */
class SectorListing extends HtmlList {
  // Optionally override render() or other methods here.

  /**
   * For example:
   */
  public function render() {
    $build = parent::render();

    // Add custom classes or wrapper here.
    $build['#attributes']['class'][] = 'listing';

    return $build;
  }

}
