<?php

/**
 * @file
 * Theme and preprocess functions for forms.
 */

use Drupal\Core\Form\FormStateInterface;

/**
 * Implements hook_theme_suggestions_HOOK_alter().
 */
function sector_theme_theme_suggestions_form_alter(array &$suggestions, array &$variables) {
  $element = $variables['element'];

  // Add a suggestion based on the form id name.
  if (isset($element['#form_id'])) {
    $suggestions[] = $variables['theme_hook_original'] . '__' . $element['#form_id'];

    if (isset($element['#view_id'])) {
      $suggestions[] = $variables['theme_hook_original'] . '__'. $element['#view_id'] . '__' . $element['#form_id'];
    }
  }


  // Check to see if the form is layout builder form
  if (isset($element['#layout_builder_element_keys'])) {
    $suggestions[] = $variables['theme_hook_original'] . '__' . 'layout__builder';
  }
}

/**
 * Implements hook_theme_suggestions_HOOK_alter().
 */
function sector_theme_theme_suggestions_form_element_alter(array &$suggestions, array &$variables, $hook) {
  $element = $variables['element'];

  // Add a suggestion based on the element type.
  if (isset($element['#type'])) {
    $suggestions[] = $variables['theme_hook_original'] . '__' . $element['#type'];
  }

  if (isset($element['#webform'])) {
    $suggestions[] = $hook . '__webform';
    $suggestions[] = $hook . '__' . $element['#type'];
  }
}

/**
 * Implements hook_preprocess_input().
 */
function sector_theme_preprocess_input(&$variables) {
  $element = $variables['element'];

  // Add the element type to the theme.
  $variables['type'] = $element['#type'];

  // Ensure there is no collision with Bootstrap 5 default class names
  // by replacing ".form-text" with ".form-textfield"
  $attributes = &$variables['attributes'];

  if ($element['#type'] === 'textfield' && !empty($attributes['class'])) {
    $classIndex = array_search('form-text', $attributes['class']);
    $attributes['class'][$classIndex] = 'form-textfield';
  }
}

/**
 * Implements hook_preprocess_form_element().
 */
function sector_theme_preprocess_form_element(&$variables) {
  $element = $variables['element'];

  // Add required class for checkbox and radio labels.
  if (in_array($element['#type'], ['checkbox', 'radio'])) {
    $variables['label']['#attributes']['class'][] = 'form-check-label';
  } else {
    $variables['label']['#attributes']['class'][] = 'form-label';
  }
}

function sector_theme_form_alter(&$form, FormStateInterface $form_state) {
  if (isset($form['#attributes']['class'])) {
    $form['#attributes']['class'][] = 'needs-validation';
  }

  $form['#validate'][] = 'validateForm';
}

function sector_theme_theme_suggestions_label_alter(array &$suggestions, array $variables, $hook) {
  $element = $variables['element'];

  if (isset($element['#webform'])) {
    $suggestions[] = $hook . '__webform';
    $suggestions[] = $hook . '__' . $element['#type'];
  }

}

function sector_theme_theme_suggestions_fieldset_alter(array &$suggestions, array $variables, $hook) {
  $element = $variables['element'];

  if (isset($element['#webform'])) {
    $suggestions[] = $hook . '__webform';
    $suggestions[] = $hook . '__' . $element['#type'];
  }
}

function sector_theme_theme_suggestions_input_alter(array &$suggestions, array $variables, $hook) {
  $element = $variables['element'];

  if (isset($element['#id'])) {
    $suggestions[] = $hook . '__' . preg_replace('/[^a-zA-Z0-9_]+/', '_', $element['#id']);
  }

  if (isset($element['#context']) && is_string($element['#context'])) {
    $suggestions[] = $hook . '__' . preg_replace('/[^a-zA-Z0-9_]+/', '_', $element['#context']);
  }

}

function validateForm(array &$form, FormStateInterface $form_state) {
  if (!empty($form_state->getErrors())) {
    $form['#attributes']['class'][] = 'was-validated';
  }
}
