<?php

namespace Drupal\secure_domain_login\EventSubscriber;

use Drupal\Core\Path\CurrentPathStack;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\HttpKernel\Event\FilterResponseEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Drupal\Core\Url;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Event Subscriber EventSubscriber.
 */
class SecureDomainLogin implements EventSubscriberInterface
{

  /**
   * The current path.
   *
   * @var \Drupal\Core\Path\CurrentPathStack
   */
  protected $currentPath;

  /**
   * The admin toolbar tools configuration.
   *
   * @var \Drupal\Core\Config\Config
   */
  protected $config;

  /**
   * The current route match.
   *
   * @var \Drupal\Core\Routing\RouteMatchInterface
   */
  protected $currentRouteMatch;

  /**
   * Constructs an EventSubscriber.
   *
   * @param \Drupal\Core\Path\CurrentPathStack $current_path
   *   The current route match.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory service.
   */
  public function __construct(CurrentPathStack $current_path, ConfigFactoryInterface $config_factory, RouteMatchInterface $route_match = NULL)
  {
    $this->currentPath = $current_path;
    $this->config = $config_factory;
    $this->currentRouteMatch = $route_match;
  }

  /**
   * Code that should be triggered on event specified.
   */
  public function onRespond(FilterResponseEvent $event) {
    $current_path = $this->currentPath->getPath();
    $current_route = \Drupal::routeMatch();
    $request = \Drupal::request();
    $current_host = $request->getHttpHost();

    // List of all the domain which are allowed for accessing the website
    // backend.
    $whitelist_domains = explode(',', $this->config->get('secure_domain_login.config')->get('whitelist_domains'));
    
    // Check to verify if the current domain is not part of allowed domain.
    if (!in_array($current_host, $whitelist_domains)) {
      if (str_contains($current_path, '/user')) {
        $redirect_url = Url::fromUri('internal:' . $this->config->get('system.site')->get('page.front'));
        $event->setResponse(new RedirectResponse($redirect_url->toString()));
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents()
  {
    $events[KernelEvents::RESPONSE][] = 'onRespond';
    return $events;
  }
}
