## Secure Password Reset Log

Drupal 11 Security Module
Author: Community Contribution
Package: Security

## OVERVIEW

Secure Password Reset Log enhances Drupal's default password reset mechanism by providing robust monitoring, auditing, and flood protection. It logs every password reset attempt and enforces configurable limits to help protect against brute-force and abuse attempts.

This module is ideal for security-conscious websites that require visibility and control over password reset behaviour while maintaining compliance and audit readiness.

## KEY FEATURES

Logs all password reset attempts

IP-based flood protection

Configurable attempt limits and time window

Admin interface to review logs

Real-time monitoring with cache disabled

Per-record delete and bulk clear functionality

Permission protected operations

User existence validation

## HOW IT WORKS

The module intercepts password reset requests at the Symfony Kernel Request level. Before the reset proceeds, it:

Checks the IP address against flood thresholds

Blocks excessive attempts with HTTP 429 response

Records attempt metadata into a custom database table

Displays all records in an administrative log interface

All flood values are configurable through a dedicated settings form.

## INSTALLATION

Place the module in:
/modules/custom/secure_password_reset_log

Enable using Drush or the admin UI:
drush en secure_password_reset_log

Clear cache:
drush cr

## CONFIGURATION

Navigate to:
Configuration → Security → Secure Password Reset Log
/admin/config/security/password-reset-flood

You can configure:

Maximum password reset attempts

Time window in seconds

Default values:

Attempts: 5

Window: 3600 seconds (1 hour)

## ADMIN INTERFACE

Navigate to:
Administration → Reports → Password Reset Logs
/admin/reports/password-reset-logs

Features include:

Chronological listing of attempts

Email and user status display

IP and timestamp logging

Delete individual logs

Clear all logs with flood reset

## PERMISSIONS

View secure password reset logs

Delete secure password reset logs

Administer secure password reset settings

Assign these via:
People → Permissions

## SECURITY CONSIDERATIONS

Prevents brute-force reset abuse

Provides forensic audit trail

Uses Drupal Flood API

Escapes output and enforces access restrictions

## DEPENDENCIES

Drupal Core User module

## TROUBLESHOOTING

If logs are not appearing:

Ensure module is enabled

Confirm permissions are assigned

Clear Drupal cache

Flood not blocking?

Verify IP detection settings

Check proxy configuration if behind load balancer

## UNINSTALLATION

Disable the module

Uninstall via Extend UI or Drush

Logs and configuration will be removed

## ROADMAP

CSV export functionality

Advanced filtering

Severity level indicators

Dashboard widgets

SUPPORT

Please create an issue on Drupal.org for bug reports or feature requests.

LICENSE

GPL-2.0-or-later