<?php

/**
 * @file
 * Implements hook_views_data().
 */

/**
 * Implements hook_views_data().
 */
function secure_password_reset_log_views_data() {
  $data = [];

  $table = 'secure_password_reset_log';

  $data[$table]['table'] = [
    'group' => t('Secure Password Reset Log'),
    'base' => [
      'field' => 'lid',
      'title' => t('Secure Password Reset Log'),
      'help' => t('Logs of secure password reset events.'),
    ],
  ];

  // Relationship to user entity.
  $data[$table]['uid'] = [
    'title' => t('User'),
    'help' => t('User associated with this reset event.'),
    'relationship' => [
      'id' => 'standard',
      'base' => 'users_field_data',
      'base field' => 'uid',
      'label' => t('User account'),
      'join' => [
        'users_field_data' => [
          'left_field' => 'uid',
          'field' => 'uid',
        ],
      ],
    ],
    'field' => [
      'id' => 'numeric',
    ],
    'filter' => [
      'id' => 'numeric',
    ],
    'sort' => [
      'id' => 'standard',
    ],
  ];

  // Log ID.
  $data[$table]['lid'] = [
    'title' => t('Log ID'),
    'help' => t('Unique log record ID.'),
    'field' => [
      'id' => 'numeric',
    ],
    'sort' => [
      'id' => 'standard',
    ],
  ];

  // Email entered in reset form.
  $data[$table]['email'] = [
    'title' => t('Email'),
    'help' => t('Email entered during password reset request.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'sort' => [
      'id' => 'standard',
    ],
  ];

  // Non existing user flag.
  $data[$table]['is_non_existing_user'] = [
    'title' => t('Invalid Email'),
    'help' => t('Indicates email does not belong to any user.'),
    'field' => [
      'id' => 'boolean',
    ],
    'filter' => [
      'id' => 'boolean',
    ],
    'sort' => [
      'id' => 'standard',
    ],
  ];

  // Action type.
  $data[$table]['action'] = [
    'title' => t('Action'),
    'help' => t('Type of reset action.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'sort' => [
      'id' => 'standard',
    ],
  ];

  // Timestamp.
  $data[$table]['timestamp'] = [
    'title' => t('Timestamp'),
    'help' => t('Time the event occurred.'),
    'field' => [
      'id' => 'date',
      'date_format' => 'short',
    ],
    'filter' => [
      'id' => 'date',
    ],
    'sort' => [
      'id' => 'date',
    ],
  ];

  // Hostname / IP address.
  $data[$table]['hostname'] = [
    'title' => t('Hostname / IP'),
    'help' => t('Originating IP address.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
  ];

  // Details column.
  $data[$table]['details'] = [
    'title' => t('Details'),
    'help' => t('Additional log information.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
  ];

  // Delete operation button.
  $data[$table]['delete_operation'] = [
    'title' => t('Operations'),
    'help' => t('Delete this log entry.'),
    'field' => [
      // The 'id' here MUST match the @ViewsField annotation ID
      // in DeleteLink.php.
      'id' => 'secure_password_reset_log_delete_link',
      // This tells the plugin which field contains the ID it needs.
      'real field' => 'lid',
    ],
  ];

  $data[$table]['user_status'] = [
    'title' => t('User Status'),
    'help' => t('Shows if the user exists or not.'),
    'field' => [
      'id' => 'secure_password_reset_log_user_status',
    ],
  ];

  return $data;
}
