<?php

namespace Drupal\secure_password_reset_log\Plugin\views\field;

use Drupal\views\Attribute\ViewsField;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Displays user existence status.
 */
#[ViewsField("secure_password_reset_log_user_status")]
class UserStatus extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function query() {
    // Prevent Views from querying this as a DB field.
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $uid = $values->secure_password_reset_log_uid ?? 0;

    if ($uid > 0) {
      return [
        '#markup' => '<span style="color:green;font-weight:bold;">✔ Existing</span>',
      ];
    }

    return [
      '#markup' => '<span style="color:red;font-weight:bold;">✖ Non-existing</span>',
    ];
  }

}
