<?php

namespace Drupal\Tests\secure_password_reset_log\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Tests that the secure_password_reset_log module is enabled.
 *
 * This is a basic example test. More comprehensive tests would involve
 * simulating password reset events and checking the log entries and flood
 * control behavior.
 *
 * @group secure_password_reset_log
 */
class PasswordResetLogTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['secure_password_reset_log', 'user', 'system'];

  /**
   * Tests that the module is enabled.
   */
  public function testModuleEnabled() {
    $module_handler = $this->container->get('module_handler');
    $this->assertTrue($module_handler->moduleExists('secure_password_reset_log'), 'The secure_password_reset_log module is enabled.');
  }

}
