<?php
// $Id: securelogin.admin.inc,v 1.1.2.8 2010/12/03 00:48:26 mfb Exp $

/**
 * Admin settings form.
 */
function securelogin_admin() {
  global $base_secure_url;
  if (variable_get('https', FALSE)) {
    drupal_set_message(t('Secure Login module expects the Drupal <code>$conf[\'https\']</code> setting to be at its default value: <code>FALSE</code>. Because it is currently enabled, secure logins cannot be fully implemented because Drupal sets insecure session cookies during login to the secure site.'), 'warning');
  }
  $form['securelogin_base_url'] = array(
    '#type'          => 'textfield',
    '#title'         => t('Secure base URL'),
    '#default_value' => variable_get('securelogin_base_url', NULL),
    '#description'   => t('The base URL for secure pages. Leave blank to allow Drupal to determine it automatically. It is not allowed to have a trailing slash; Drupal will add it for you. For example: %base_secure_url%. Note that in order for cookies to work, the hostnames in the secure base URL and the insecure base URL must be in the same domain as per the appropriate setting in <code>settings.php</code>, which you may need to modify.', array('%base_secure_url%' => $base_secure_url)),
  );
  $form['securelogin_secure_forms'] = array(
    '#type'          => 'checkbox',
    '#title'         => t('Redirect form pages to secure URL'),
    '#default_value' => variable_get('securelogin_secure_forms', TRUE),
    '#description'   => t('If enabled, any pages containing the forms enabled below will be redirected to the secure URL. Users can be assured that they are entering their private data on a secure URL, the contents of which have not been tampered with.'),
  );
  $form['required'] = array(
    '#type'          => 'fieldset',
    '#title'         => t('Required forms'),
    '#description'   => t('These forms must be secured in order to implement basic secure login functionality.'),
  );
  $form['required']['securelogin_form_user_login'] = array(
    '#type'          => 'checkbox',
    '#title'         => t('Secure user login form'),
    '#default_value' => variable_get('securelogin_user_login', TRUE),
    '#description'   => t('If enabled, the user login form will be submitted to the secure URL.'),
  );
  $form['required']['securelogin_form_user_login_block'] = array(
    '#type'          => 'checkbox',
    '#title'         => t('Secure user login block form'),
    '#default_value' => variable_get('securelogin_form_user_login_block', TRUE),
    '#description'   => t('If enabled, the user login block form will be submitted to the secure URL.'),
  );
  $form['required']['securelogin_form_user_profile_form'] = array(
    '#type'          => 'checkbox',
    '#title'         => t('Secure user edit form'),
    '#default_value' => variable_get('securelogin_form_user_profile_form', TRUE),
    '#description'   => t('If enabled, the user edit form will be submitted to the secure URL.'),
  );
  $form['optional'] = array(
    '#type'          => 'fieldset',
    '#title'         => t('Optional forms'),
    '#description'   => t('Other forms accessible to anonymous users may optionally be secured.'),
  );
  // Registration form is also a login form if e-mail verification is disabled.
  $register = variable_get('user_email_verification', TRUE) ? 'optional' : 'required';
  $form[$register]['securelogin_form_user_register_form'] = array(
    '#type'          => 'checkbox',
    '#title'         => t('Secure user registration form'),
    '#default_value' => variable_get('securelogin_form_user_register_form', TRUE),
    '#description'   => t('If enabled, the user registration form will be submitted to the secure URL.'),
  );
  $form['optional']['securelogin_form_node_form'] = array(
    '#type'          => 'checkbox',
    '#title'         => t('Secure node form'),
    '#default_value' => variable_get('securelogin_form_node_form', TRUE),
    '#description'   => t('If enabled, node forms will be submitted to the secure URL.'),
  );
  $form['optional']['securelogin_form_comment_form'] = array(
    '#type'          => 'checkbox',
    '#title'         => t('Secure comment form'),
    '#default_value' => variable_get('securelogin_form_comment_form', TRUE),
    '#description'   => t('If enabled, comment forms will be submitted to the secure URL.'),
  );
  return system_settings_form($form);
}

/**
 * Admin settings form validation handler.
 */
function securelogin_admin_validate($form, &$form_state) {
  if (empty($form_state['values']['securelogin_base_url'])) {
    $form_state['values']['securelogin_base_url'] = NULL;
  }
  elseif (!valid_url($form_state['values']['securelogin_base_url'], TRUE)) {
    form_set_error('securelogin_base_url', t('The secure base URL must be a valid URL.'));
  }
  elseif (strtolower(parse_url($form_state['values']['securelogin_base_url'], PHP_URL_SCHEME)) !== 'https') {
    form_set_error('securelogin_base_url', t('The secure base URL must start with <em>https://</em>.'));
  }
}
