# Secure Login module

Secure Login module enables secure logins by submitting the login form
to a secure host address.  The module can also do the same for the user
edit, user registration, and other forms, so that passwords and other
data are never sent in cleartext.

A secure login to Drupal 7 by default generates an [HTTPS-only secure
session](https://php.net/manual/session.configuration.php#ini.session.cookie-secure),
which also prevents session cookies from being sent in cleartext.  Note,
however, that if you have enabled Drupal's hidden `$conf['https']`
setting, sessions are shared across HTTP and HTTPS, which makes user
sessions vulnerable to [session hijacking
attacks](https://en.wikipedia.org/wiki/Session_hijacking). Secure Login
module is therefore designed for sites that have left `$conf['https']`
at its default value, `FALSE`.


## Installation

0. Before enabling the module, you need to set up your server to support
   SSL.  You can use [Certbot](https://certbot.eff.org/) to obtain a
   free SSL certificate.  The result should be that if your Drupal site
   lives at http://host.example.org/dir/, it should also be accessible
   at https://host.example.org/dir/ (if necessary, you can use the
   secure base URL setting to specify a different secure base URL e.g.
   https://otherhost.example.org/otherdir/).  If you use a different URL
   for the secure site, you must make sure that cookies coming from
   host.example.org can be sent to otherhost.example.org.  You can
   change the cookie domain in settings.php.
1. Ensure the HTTPS version of your site works. Note: In certain server
   environments, you may need to set PHP's `$_SERVER['HTTPS']` variable
   to "on" when the site is accessed via HTTPS (either in your webserver
   configuration or in your settings.php file).
2. If you have set the `$base_url` variable in your settings.php file,
   ensure that the URL scheme matches the scheme used to access the
   site.  For example:

        $base_url = (drupal_is_https() ? 'https' : 'http') . '://example.org';

3. Untar the module into your Drupal modules directory.
4. Read the README.md before enabling the module and before upgrading!
5. Enable the module at admin/modules.
6. Configure the module at admin/config/people/securelogin.


## Uninstallation

If you did not follow step 1 above, or you copied your Drupal site to a
local instance which does not have HTTPS enabled, you may not be able to
login to your Drupal site to disable Secure Login module normally.
Instead you will need to:

1. Run `drush dis securelogin` or delete the securelogin directory
   from your modules directory.
2. Run `drush cc all` or truncate (delete all entries in) the
   cache_page database table.
3. Clear your browser cache.


## Configuration

At admin/config/people/securelogin you can set which forms (login, login
block, user edit, user registration, node, comment, contact, webform,
etc.) are secured by this module.  By securing all forms in the
"required" group on the settings page, you can ensure that logins are in
fact "secure": all authenticated sessions will use SSL-only secure
session cookies which are immune to session hijacking by eavesdroppers.


## Upgrading from Drupal 6

Your Secure Login settings should be correctly migrated from Drupal 6 to
Drupal 7.  Note, however, that the Drupal 7 version of Secure Login does
not currently support redirecting a secure authenticated session back to
the HTTP site.  Doing so would require creating an insecure session,
which would be vulnerable to session hijacking and is thus not a secure
configuration.


## Developer API

This module provides two API functions for developers:

- `securelogin_secure_form($form)` may be added to a hook_form_alter
  implementation to cause a form to submit to the secure URL.
- `securelogin_secure_redirect()` may be called to redirect the current
  request to the equivalent path on the secure base URL.

In addition, developers may use `$form['#https'] = TRUE` to indicate
that a form should be secured by Secure Login module, and
`$options['https'] = TRUE` to indicate that an HTTPS URL should be
generated by the `url()` function, as well as other functions that use
`url()` internally such as `drupal_goto()`.
