# Security Audit Checklist

The **Security Audit Checklist** module provides a simple, centralized checklist of best practices to help improve the security of a Drupal site.  
It is intended to guide site administrators and developers in applying recommended configurations, modules, and server-level hardening steps.

## Requirements (required)

This module requires the following modules:

- [Checklist API](https://www.drupal.org/project/checklistapi)


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

To start using the module, go to `/admin/config/development/security_audit_checklist`. It will
pre-check any completed items it is able to auto detect. Start working through
the rest, and click "Save" to save your progress!

## Features

This module displays a list of recommended security measures for a Drupal site, 
For Example:
- Enable Two-Factor Authentication
- Security Headers
- File Permissions
- Secure Cookies
- Update Manager Restrictions 
etc...