<?php

namespace Drupal\security_login_secure\Form\Section;

use Drupal\Core\Form\FormStateInterface;
use Drupal\security_login_secure\Utilities;
use Drupal\security_login_secure\Form\WebsiteSecurityIPBlocking;
use Drupal\security_login_secure\MiniorangeWebsiteSecurityConstants;

/**
 * Form handler for Advanced blocking settings.
 */
class HoneypotConfigurationForm extends WebsiteSecurityIPBlocking
{
    /**
     * {@inheritdoc}
     */
    public function build_honeypot_configuration_form(array &$form, FormStateInterface $form_state)
    {
        global $base_url;
        $info_icon_url = Utilities::get_info_icon();
        $disabled = TRUE;

        $form['honeypot_settings'] = [
            '#type' => 'details',
            '#group' => 'information',
            '#title' => $this->t('Honeypot Protection'),
        ];

        $form['honeypot_settings']['honeypot_enabled_forms'] = [
            '#type' => 'checkbox',
            '#title' => $this->t('<b>Enable Honeypot on Forms <a href=":premium_url">[Premium]</a></b>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#description' => $this->t('Select forms to protect with a honeypot field.'),
            '#disabled' => $disabled
        ];

        $form['honeypot_settings']['honeypot_attempts_to_block_ip'] = [
            '#type' => 'textfield',
            '#title' => $this->t('Attempts to Block IP <a href=":premium_url">[Premium]</a>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#disabled' => $disabled,
            '#description' => $this->t('Number of failed honeypot attempts before blocking the IP.'),
            '#validators' => [
                'numeric' => [
                    'message' => $this->t('Please enter a valid number of seconds.'),
                ],
            ],
        ];

        $form['honeypot_settings']['honeypot_enabled_logs'] = [
            '#type' => 'checkbox',
            '#title' => $this->t('<b>Log Honeypot Submissions <a href=":premium_url">[Premium]</a></b>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#description' => $this->t('Enable logging of honeypot-triggered submissions.'),
            '#disabled' => $disabled
        ];

        $form['honeypot_settings']['honeypot_delete_logs_in_seconds'] = [
            '#type' => 'textfield',
            '#title' => $this->t('Honeypot delete logs after (seconds)<a href=":premium_url">[Premium]</a>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#disabled' => $disabled,
            '#description' => $this->t('Time in seconds after which honeypot logs will be deleted. Default is 1 day (86400 seconds).'),
            '#validators' => [
                'numeric' => [
                    'message' => $this->t('Please enter a valid number of seconds.'),
                ],
            ],
        ];

        $form['honeypot_settings']['honeypot_field_label'] = [
            '#type' => 'textfield',
            '#title' => $this->t('Honeypot Field Label <a href=":premium_url">[Premium]</a>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#disabled' => $disabled,
            '#description' => $this->t('Label for the honeypot field (hidden from users).'),
        ];

        $form['honeypot_settings']['honeypot_error_message'] = [
            '#type' => 'textfield',
            '#title' => $this->t('Honeypot Error Message <a href=":premium_url">[Premium]</a>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#disabled' => $disabled,
            '#description' => $this->t('Message shown when honeypot is triggered.'),
        ];
    }
}
