<?php

/**
 * @file
 * Contains \Drupal\security_login_secure\Form\WebsiteSecurityConfiguration.
 */

namespace Drupal\security_login_secure\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Render\Markup;
use Drupal\security_login_secure\Utilities;

class WebsiteSecurityConfiguration extends FormBase
{

    public function getFormId()
    {
        return 'mo_website_security_configuration';
    }

    public function buildForm(array $form, FormStateInterface $form_state)
    {
        $info_icon_url = Utilities::get_info_icon();
        $db_var = $this->config('security_login_secure.settings');

        $form['markup_library'] = array(
            '#attached' => array(
                'library' => array(
                    "security_login_secure/security_login_secure.admin",
                )
            )
        );


        $form['markup_top'] = array(
            '#markup' => '<div class="ns_table_layout_1"><div class="ns_table_layout ns_container">'
        );

        $form['information'] = [
            '#type' => 'vertical_tabs',
            '#default_tab' => 'edit-bruteforce_ip',
        ];

        // Build form elements from child classes.
        $this->buildBruteForceIpForm($form, $form_state);
        $this->buildBruteForceUserForm($form, $form_state);

        $form['website_security_user_config_submit'] = array(
            '#type' => 'submit',
            '#value' => $this->t('Save Configurations'),
            '#limit_validation_errors' => array(),
            '#prefix' => '',
            '#suffix' => '</div>',
            '#attributes' => array('class' => ['button--primary'])
        );

        $form['dummy'] = array(
            '#markup' => '</div></div></div>',
        );

        $form['main_layout_div_end_1'] = array(
            '#markup' => '<div>',
        );

        return $form;
    }

    public function submitForm(array &$form, FormStateInterface $form_state): void
    {
        $this->submitBruteForceIpForm($form, $form_state);
        $this->submitBruteForceUserForm($form, $form_state);
        $this->messenger()->addStatus($this->t('Configurations has been saved successfully.'));
    }

    /**
     * Builds the brute force IP protection form elements.
     */
    public function buildBruteForceIpForm(array &$form, FormStateInterface $form_state)
    {
        // This will be implemented by BruteForceIpForm class.
    }

    /**
     * Builds the brute force user protection form elements.
     */
    public function buildBruteForceUserForm(array &$form, FormStateInterface $form_state)
    {
        // This will be implemented by BruteForceUserForm class.
    }

    /**
     * Builds the strong password protection form elements.
     */
    public function buildStrongPasswordForm(array &$form, FormStateInterface $form_state)
    {
        // This will be implemented by StrongPasswordForm class.
    }

    /**
     * Submits the brute force IP protection form.
     */
    public function submitBruteForceIpForm(array &$form, FormStateInterface $form_state)
    {
        // This will be implemented by BruteForceIpForm class.
    }

    /**
     * Submits the brute force user protection form.
     */
    public function submitBruteForceUserForm(array &$form, FormStateInterface $form_state)
    {
        // This will be implemented by BruteForceUserForm class.
    }
}
