<?php

namespace Drupal\security_login_secure\Hook;

use Symfony\Component\HttpFoundation\RedirectResponse;

class MiniorangeWebsiteSecurityHooks
{
    public function login_form_hook($form, $form_id)
    {
        $db_var = \Drupal::config('security_login_secure.settings');
        $miniorangeIPSecurityRepository = \Drupal::service('security_login_secure.ip_security_repository');
        $enable_ip_blocking = $db_var->get('website_security_enable_ip_blocking');

        if ($enable_ip_blocking == 1) {
            // If IP Blocking is enabled then we will check that is Client IP in the list of blocking. If client IP is in the blocking list then we will show 403 page to the user. 
            if ($miniorangeIPSecurityRepository->mo_website_security_is_ip_blacklisted()) {
                global $base_url;
                $response = new RedirectResponse($base_url . '/error_403_page');
                $response->send();
            }
        }

        if ($form_id == 'user_login_form') {
            $form['#validate'][] = 'website_security_validate';
        }

        \Drupal::service('page_cache_kill_switch')->trigger();
    }

    /**
     * Validates the login form submission.
     */
    public function mo_website_security_validate(&$form, &$form_state)
    {
        global $base_url;

        $username = $form_state->getValue('name');
        $password = $form_state->getValue('pass');

        if (empty($username) || empty($password)) {
            return;
        }

        $authenticate = \Drupal::service('user.auth')->authenticate($username, $password);

        $account = user_load_by_name($username);

        $ip_address = \Drupal::request()->getClientIp();

        $db_var = \Drupal::config('security_login_secure.settings');
        $whitelist_users = $db_var->get('website_security_disable_user_blocking');
        $enable_ip_bruteforce = $db_var->get('website_security_ip_enable_bruteforce');
        $enable_user_bruteforce = $db_var->get('website_security_user_enable_bruteforce');

        $miniorangeIPSecurityRepository = \Drupal::service('security_login_secure.ip_security_repository');
        $miniorangeUserSecurityRepository = \Drupal::service('security_login_secure.user_security_repository');

        // The IP's that were blocked due to failed login attempts will be unblocked in this function if there blocking time has been expired.
        $miniorangeIPSecurityRepository->mo_website_security_clear_events_ips($ip_address, $username);

        // Here we will check if client IP is blocked due to failed login attempts then we need to show him the error message.
        if ($miniorangeIPSecurityRepository->mo_website_security_is_current_ip_blocked($ip_address)) {
            $form_state->clearErrors();
            $form_state->setErrorByName('test', t('IP BLOCKED: Your IP is blocked. Please contact your administrator.'));
            return;
        }

        // If the client IP is whitelisted then we need not to block the user IP even if client makes various failed login attempts.
        if ($miniorangeIPSecurityRepository->mo_website_security_is_ip_whitelisted($ip_address)) {
            // If whitelist user attempts checkbox is checked then user will not get blocked bcz of Drupal default behaviour (blocks user for 5 failed login attempts)
            if ($whitelist_users == 1)
                $miniorangeUserSecurityRepository->mo_website_security_clear_flood_table_events_user();

            // This is to ensure that if client IP is whitelisted then that IP should never get blocked due to Drupal default behaviour (blocks IP for 25 or 30 failed login attempts)
            $miniorangeIPSecurityRepository->mo_website_security_clear_flood_table_events_ip();
        }

        // If IP bruteforce is enabled and client IP is not whitelisted then we will perform IP bruteforce protection
        if ($enable_ip_bruteforce == 1 && !$miniorangeIPSecurityRepository->mo_website_security_is_ip_whitelisted($ip_address)) {
            $miniorangeIPSecurityManager = \Drupal::service('security_login_secure.ip_security_manager');
            $miniorangeIPSecurityManager->initiateIPSecurityChecks($ip_address, $username, $authenticate, $db_var,  $form_state);
        }

        // If user bruteforce is enabled and client IP is not whitelisted then we will perform user bruteforce protection
        if ($enable_user_bruteforce == 1 && !$miniorangeIPSecurityRepository->mo_website_security_is_ip_whitelisted($ip_address)) {

            $miniorangeUserSecurityManager = \Drupal::service('security_login_secure.user_security_manager');
            $miniorangeUserSecurityManager->initiateUserSecurityChecks($ip_address, $account, $username, $authenticate, $db_var,  $form_state);
        }
    }
}
