# Configuration Guide

## Overview

The Security Login Secure module provides comprehensive security features for Drupal sites. This guide covers all configuration options and their recommended settings.

## Basic Configuration

### 1. Access Settings
Navigate to `/admin/config/people/security_login_secure/`

#### IP Blocking
- **Maximum Failed Attempts**: Number of failed attempts before IP blocking 
- **Block Duration**: Time period for IP blocking
- **Whitelist IPs**: Add trusted IP addresses
- **Blacklist IPs**: Add blocked IP addresses

#### User Blocking
- **Maximum Failed Attempts**: Number of failed attempts before user blocking
- **Block Duration**: Time period for user blocking
- **Notify User**: Send email notification to user when blocked

### 2. Email Notifications

#### Admin Notifications
- **Enable Admin Notifications**: Toggle admin email notifications
- **Admin Email**: Primary admin email for notifications
- **Notification Threshold**: Number of failed attempts before notification
- **Notification Frequency**: How often to send notifications

#### User Notifications
- **Enable User Notifications**: Toggle user email notifications
- **Notification Template**: Customize email message
- **Include IP Address**: Add IP address to notifications
- **Include Timestamp**: Add time of attempt to notifications

## Advanced Configuration

### 1. Security Policies

#### Password Policy
- **Minimum Length**: Minimum password length
- **Complexity Requirements**: Password complexity rules
- **Password History**: Number of previous passwords to remember
- **Password Expiry**: Password expiration period

#### Session Security
- **Session Timeout**: Inactive session timeout
- **Concurrent Sessions**: Maximum concurrent sessions
- **Session IP Binding**: Bind sessions to IP addresses
- **Remember Me**: Enable/disable remember me functionality

### 2. Reporting

#### Log Settings
- **Enable Logging**: Toggle security event logging
- **Log Level**: Detail level for logging
- **Log Retention**: How long to keep logs
- **Log Format**: Customize log format

#### Report Generation
- **Report Frequency**: How often to generate reports
- **Report Format**: CSV
- **Report Recipients**: Email addresses for reports
- **Report Content**: What to include in reports

## Integration Settings

### 1. Third-Party Integration

#### OAuth
- **Enable OAuth**: Toggle OAuth integration
- **Provider Settings**: Configure OAuth providers
- **User Mapping**: Map OAuth fields to user fields
- **Role Assignment**: Assign roles based on OAuth

### 2. API Configuration

#### REST API
- **Enable API**: Toggle REST API access
- **API Key**: Your API key
- **Rate Limiting**: API request limits
- **Allowed IPs**: IPs allowed to access API

## Performance Settings

### 1. Caching

#### Cache Configuration
- **Enable Caching**: Toggle security cache
- **Cache Lifetime**: How long to cache security data
- **Cache Tags**: Tags for cache invalidation
- **Cache Bins**: Which cache bins to use

#### Rate Limiting
- **Enable Rate Limiting**: Toggle rate limiting
- **Request Limit**: Maximum requests per period
- **Time Window**: Time period for rate limiting
- **Bypass Rules**: Rules to bypass rate limiting

### 2. Optimization

#### Database Optimization
- **Table Optimization**: Schedule table optimization
- **Index Management**: Manage database indexes
- **Query Optimization**: Optimize security queries
- **Connection Pooling**: Configure connection pooling

#### Resource Management
- **Memory Limit**: Maximum memory usage
- **CPU Usage**: Maximum CPU usage
- **Process Management**: Manage background processes
- **Resource Monitoring**: Monitor resource usage