<?php

/**
 * @file
 * Contains \Drupal\security_login_secure\Form\WebsiteSecurityLicensing.
 */

namespace Drupal\security_login_secure\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\FormBase;
use Drupal\security_login_secure\Utilities;
use Drupal\security_login_secure\Repository\MiniorangeReportsRepository;
use Symfony\Component\DependencyInjection\ContainerInterface;

class WebsiteSecurityIPBlocking extends FormBase
{

    /**
     * @var MiniorangeReportsRepository
     */
    protected $miniorangeReportsRepository;

    /**
     * Constructor.
     */
    public function __construct(MiniorangeReportsRepository $miniorangeReportsRepository)
    {
        $this->miniorangeReportsRepository = $miniorangeReportsRepository;
    }

    /**
     * {@inheritdoc}
     */
    public static function create(ContainerInterface $container)
    {
        return new static(
            $container->get('security_login_secure.reports_repository')
        );
    }

    public function getFormId(): string
    {
        return 'mo_website_security_ipblocking_whitelisting';
    }

    public function buildForm(array $form, FormStateInterface $form_state)
    {

        global $base_url;
        $info_icon_url = Utilities::get_info_icon();
        $db_var = $this->config('security_login_secure.settings');

        $form['markup_library'] = array(
            '#attached' => array(
                'library' => array(
                    "security_login_secure/security_login_secure.admin",
                )
            )
        );

        $form['markup_top'] = array(
            '#markup' => '<div class="ns_table_layout_1"><div class="ns_table_layout ns_container">'
        );

        $form['information'] = [
            '#type' => 'vertical_tabs',
            '#default_tab' => 'edit-publication',
        ];

        // Build form elements from child classes.
        $this->build_ip_blocking_form($form, $form_state);
        $this->build_advanced_blocking_form($form, $form_state);
        $this->build_role_login_ip_config_form($form, $form_state);
        $this->build_honeypot_configuration_form($form, $form_state);
        $this->build_backup_configuration_form($form, $form_state);
        $this->build_vulnerability_scanner_form($form, $form_state);

        $form['website_security_save'] = [
            '#type' => 'submit',
            '#value' => $this->t('Save Configurations'),
            '#attributes' => array('class' => ['button--primary'])
        ];

        $form['last'] = [
            '#markup' => '</div>',
        ];

        $form['main_layout_div_end_1'] = array(
            '#markup' => '<div>',
        );

        return $form;
    }

    public function submitForm(array &$form, FormStateInterface $form_state)
    {

        $this->submit_ip_blocking_form($form, $form_state);
        $this->submit_vulnerability_scanner_form($form, $form_state);

        if (!\Drupal::state()->get('warning_in_saving_config', FALSE))
            $this->messenger()->addMessage($this->t('Configurations has been saved successfully.'));

        \Drupal::state()->set('warning_in_saving_config', FALSE);
    }

    public function build_ip_blocking_form(array &$form, FormStateInterface $form_state) {}

    public function build_advanced_blocking_form(array &$form, FormStateInterface $form_state) {}

    public function build_role_login_ip_config_form(array &$form, FormStateInterface $form_state) {}

    public function build_honeypot_configuration_form(array &$form, FormStateInterface $form_state) {}

    public function build_backup_configuration_form(array &$form, FormStateInterface $form_state) {}

    public function build_vulnerability_scanner_form(array &$form, FormStateInterface $form_state) {}

    public function submit_ip_blocking_form(array &$form, FormStateInterface $form_state) {}

    public function submit_vulnerability_scanner_form(array &$form, FormStateInterface $form_state) {}
}
