<?php

/**
 * @file
 * Contains \Drupal\security_login_secure\Form\WebsiteSecurityLicensing.
 */

namespace Drupal\security_login_secure\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\FormBase;
use Drupal\security_login_secure\Utilities;
use Drupal\Core\Render\Markup;

class WebsiteSecurityLicensing extends FormBase
{
    public function getFormId()
    {
        return 'mo_website_security_licensing_new';
    }

    public function buildForm(array $form, FormStateInterface $form_state)
    {
        global $base_url;
        $module_path = $base_url . '/' . \Drupal::service('extension.list.module')->getPath("security_login_secure");

        // Feature boxes
        $features = [
            [
                'title' => 'Advanced Blocking',
                'description' => 'Block users based on: IP range, Country Blocking.',
            ],
            [
                'title' => 'Role based IP Configuration',
                'description' => 'Allow users to configure IP addresses based on their roles.',
            ],
            [
                'title' => 'DOS Protection',
                'description' => 'Protect your website from Denial of Service attacks.',
            ],
            [
                'title' => 'Enforce Strong Password',
                'description' => 'Enforce strong password policy for your website.',
            ],
            [
                'title' => 'HoneyPot',
                'description' => 'Create a honey pot to catch attackers.',
            ],
            [
                'title' => 'Backup Files and Database',
                'description' => 'Backup your website files and database.',
            ],
        ];

        $related_products = [
            [
                'title' => 'SAML SP Provider',
                'description' => 'miniOrange provides Drupal SAML SP as a Single Sign-On solution that allows you to login to your Drupal site using SAML 2.0 compliant Identity Provider credentials. You can easily configure the Identity Provider with your Drupal site by simply providing a metadata URL or metadata file.',
                'image' => 'SAML-SP.webp',
                'link' => 'https://plugins.miniorange.com/drupal-saml-single-sign-on-sso',
            ],
            [
                'title' => 'OAuth Client',
                'description' => 'OAuth/OpenID Connect Client SSO (OAuth 2.0) module allows users residing at the OAuth Provider’s side to login to your Drupal site. The module syncs with all OAuth/OpenID providers that conform to OAuth 2.0 or OpenID Connect 1.0 standards.',
                'image' => 'Oauth-Client.webp',
                'link' => 'https://plugins.miniorange.com/drupal-sso-oauth-openid-single-sign-on'
            ],
            [
                'title' => 'Two Factor Authentication',
                'description' => 'Second-Factor Authentication (TFA) adds a second layer of security with an option to configure truly Passwordless Login. You can configure the module to send an OTP to your preferred mode of communication like phone/email, integrate with TOTP Apps like Google Authenticator or configure hardware token 2FA method.',
                'image' => 'Two-Factor.webp',
                'link' => 'https://plugins.miniorange.com/drupal-two-factor-authentication-2fa'
            ],
            [
                'title' => 'OTP Verification',
                'description' => 'Drupal OTP Verification module verifies Email Address/Mobile Number of users by sending verification code(OTP) during registration. It eliminates the possibility of a user registering with invalid personal details (phone number or email) on the Drupal site.',
                'image' => 'OTP-verify.webp',
                'link' => 'https://plugins.miniorange.com/drupal-otp-verification'
            ],
            [
                'title' => 'REST API Authentication',
                'description' => 'Drupal REST & JSON API Authentication module secures your Drupal site APIs against unauthorized access by enforcing different authentication methods including Basic Authentication, API Key Authentication, JWT Authentication, Third-Party Provider Authentication, etc.',
                'image' => 'REST-API.webp',
                'link' => 'https://plugins.miniorange.com/drupal-rest-api-authentication'
            ],
            [
                'title' => 'Session Management',
                'description' => 'User Session Management module helps you to manage the Drupal user session-related operations. It efficiently handles user sessions and provides you with multiple features like terminating any user session from the admin section, auto-logout user on being idle for the configured amount of time, limiting the number of simultaneous sessions per user, IP-based login restrictions, and many more.',
                'image' => 'Session-Management.webp',
                'link' => 'https://plugins.miniorange.com/drupal-session-management'
            ],
        ];

        $form['markup_library'] = array(
            '#attached' => array(
                'library' => array(
                    "security_login_secure/security_login_secure.admin"
                )
            )
        );

        // Current Plan Section
        $form['current_plan_section'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['current-plan-section']
            ],
        ];

        // Left side content
        $form['current_plan_section']['plan_info'] = [
            '#type' => 'container',
            '#attributes' => ['class' => ['plan-info']],
        ];

        $form['current_plan_section']['plan_info']['plan_type'] = [
            '#type' => 'markup',
            '#markup' => 'Current Plan: Community Version',
        ];

        $form['current_plan_section']['plan_info']['module_info'] = [
            '#type' => 'markup',
            '#markup' => '<h3>Website Security Pro</h3>',
            '#attributes' => ['class' => ['module-info']],
        ];

        $form['current_plan_section']['plan_info']['version_info'] = [
            '#type' => 'markup',
            '#markup' => 'Version: ' . Utilities::getModuleVersion(),
        ];

        // Right side upgrade button
        $form['current_plan_section']['upgrade_button'] = [
            '#type' => 'link',
            '#title' => t('Upgrade Plan'),
            '#url' => \Drupal\Core\Url::fromUri('https://plugins.miniorange.com/drupal-web-security-pro'),
            '#attributes' => [
                'class' => ['button', 'button--primary'],
            ],
            '#target' => '_blank',
        ];

        // Premium Features Section
        $form['premium_features_section'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['section-container'],
            ],
        ];

        $form['premium_features_section']['title'] = [
            '#type' => 'markup',
            '#markup' => '<h3>Enterprise Features</h3>',
            '#prefix' => '<div class="section-title">',
        ];

        $form['premium_features_section']['upgrade-button'] = [
            '#type' => 'link',
            '#title' => t('View All Features'),
            '#url' => \Drupal\Core\Url::fromUri('https://plugins.miniorange.com/drupal-web-security-pro'),
            '#attributes' => [
                'class' => ['button', 'button--primary'],
            ],
            '#target' => '_blank',
            '#suffix' => '</div>',
        ];

        // Features Grid Container
        $form['premium_features_section']['features_grid'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['features-grid'],
            ],
        ];

        foreach ($features as $index => $feature) {
            $form['premium_features_section']['features_grid']['feature_' . $index] = [
                '#type' => 'container',
                '#attributes' => [
                    'class' => ['feature-box']
                ],
            ];

            $form['premium_features_section']['features_grid']['feature_' . $index]['content'] = [
                '#type' => 'markup',
                '#markup' => '<h5>' . $feature['title'] . '</h5>' . $feature['description'],
            ];
        }

        // Related Products Section
        $form['related_products_section'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['section-container'],
            ],
        ];

        $form['related_products_section']['title'] = [
            '#type' => 'markup',
            '#markup' => '<h3>Related Products</h3>',
            '#prefix' => '<div class="section-title">',
        ];

        $form['related_products_section']['upgrade-button'] = [
            '#type' => 'link',
            '#title' => t('View All Products'),
            '#url' => \Drupal\Core\Url::fromUri('https://plugins.miniorange.com/drupal'),
            '#attributes' => [
                'class' => ['button', 'button--primary'],
            ],
            '#target' => '_blank',
            '#suffix' => '</div>',
        ];

        // Features Grid Container
        $form['related_products_section']['features_grid'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['features-grid']
            ],
        ];

        // Feature boxes with images

        foreach ($related_products as $index => $product) {
            $form['related_products_section']['features_grid']['feature_' . $index] = [
                '#type' => 'container',
                '#attributes' => [
                    'class' => ['feature-box']
                ],
            ];

            $form['related_products_section']['features_grid']['feature_' . $index]['title'] = [
                '#type' => 'markup',
                '#markup' => '<h5>' . $product['title'] . '</h5><hr>',
            ];

            // Image
            $form['related_products_section']['features_grid']['feature_' . $index]['image'] = [
                '#type' => 'markup',
                '#markup' => $this->t('<div><img class="feature-image" src=":module_path/includes/images/:image" alt=":title"></div>', [
                    ':module_path' => $module_path,
                    ':image' => $product['image'],
                    ':title' => $product['title'],
                ]),
            ];

            // Title and Description
            $form['related_products_section']['features_grid']['feature_' . $index]['content'] = [
                '#type' => 'markup',
                '#markup' => '<span class="product-description">' . $product['description'] . '</span>',
            ];

            // View Details Button
            $form['related_products_section']['features_grid']['feature_' . $index]['button'] = [
                '#type' => 'link',
                '#title' => t('View Details'),
                '#url' => \Drupal\Core\Url::fromUri($product['link']),
                '#attributes' => [
                    'class' => ['button', 'button--primary'],
                    'style' => 'margin-top: 10px;',
                ],
                '#target' => '_blank',
            ];
        }

        $rows = [
            [Markup::create($this->t('<b>1.</b> Click on Upgrade Now button for required licensed plan and you will be redirected to miniOrange login console.</li>')), Markup::create(t('<b>5.</b> Uninstall and then delete the free version of the module from your Drupal site.'))],
            [Markup::create($this->t('<b>2.</b> Enter your username and password with which you have created an account with us. After that you will be redirected to payment page.')), Markup::create(t('<b>6.</b> Now install the downloaded licensed version of the module.'))],
            [Markup::create($this->t('<b>3.</b> Enter your card details and proceed for payment. On successful payment completion, the Licensed version module(s) will be available to download.')), Markup::create(t('<b>7.</b> Clear Drupal Cache from <a href="' . $base_url . '/admin/config/development/performance" >here</a>.'))],
            [Markup::create($this->t('<b>4.</b> Download the licensed module(s) from Module Releases and Downloads section.')), Markup::create($this->t('<b>8.</b> After enabling the licensed version of the module, login using the account you have registered with us.'))],
        ];

        $form['markup_how to upgrade'] = array(
            '#markup' => '<h3 class="mo_saml_text_center"><br>How to Upgrade to Licensed Version Module</h3>'
        );

        $form['miniorange_how_to_upgrade_table'] = array(
            '#type' => 'table',
            '#responsive' => TRUE,
            '#rows' => $rows,
            '#attributes' => ['style' => 'border: 1px solid #ddd; width: 100%;'],
        );

        return $form;
    }

    public function submitForm(array &$form, FormStateInterface $form_state) {}
}
