# Installation Guide

## System Requirements

- Drupal 8.x or higher
- PHP 7.3 or higher
- MySQL 5.7 or higher
- Sufficient database permissions for table creation

## Installation Steps

### 1. Download the Module
```bash
# Using Composer
composer require drupal/security_login_secure

# Or manually download from Drupal.org
# Place the module in web/modules/security_login_secure
```

### 2. Enable the Module
```bash
# Using Drush
drush en security_login_secure

# Or through Drupal UI
# Navigate to Extend > Install new module
```

### 3. Database Setup
The module will automatically create necessary database tables during installation:
- `mo_website_security_user_attempts`
- `mo_website_security_ip_attempts`
- `mo_website_security_reports`

### 4. Verify Installation
1. Check the status report at `/admin/reports/status`
2. Verify module appears in the list of installed modules
3. Check for any installation errors in the logs

## Post-Installation Steps

### 1. Clear Cache
```bash
# Using Drush
drush cr

# Or through Drupal UI
# Navigate to Configuration > Development > Performance > Clear all caches
```

### 2. Set Initial Configuration
1. Navigate to `/admin/config/people/security_login_secure/`
2. Configure basic security settings
3. Set up email notifications

### 3. Test the Installation
1. Try logging in with incorrect credentials
2. Verify IP blocking functionality
3. Check email notifications

## Common Installation Issues

### 1. Database Errors
- Ensure database user has sufficient permissions
- Check database connection settings
- Verify database tables are created correctly

### 2. Module Dependencies
- Check if all required modules are enabled
- Verify module compatibility with Drupal version
- Check for any conflicting modules

### 3. Permission Issues
- Verify file permissions in the module directory
- Check web server user permissions
- Ensure proper access to configuration files

## Security Considerations

### 1. File Permissions
```bash
# Set proper file permissions
chmod 755 web/modules/security_login_secure
chmod 644 web/modules/security_login_secure/*.php
```

### 2. Database Security
- Use strong database passwords
- Limit database user permissions
- Regular database backups

### 3. Server Configuration
- Enable SSL/TLS
- Configure proper PHP settings
- Set up secure file permissions

## Uninstallation

### 1. Backup Data
- Export security logs
- Backup configuration
- Save IP whitelist/blacklist

### 2. Uninstall Module
```bash
# Using Drush
drush pmu security_login_secure

# Or through Drupal UI
# Navigate to Extend > Uninstall
```

### 3. Clean Up
- Remove module files
- Clear cache
- Check for any remaining database tables

## Support and Resources

### 1. Documentation
- Read the [Technical Workflow](technical-workflow.md)
- Check the [Configuration Guide](configuration.md)
- Review [Troubleshooting Guide](troubleshooting.md)

### 2. Community Support
- Drupal.org issue queue
- Security module documentation
- Community forums

### 3. Professional Support
- Contact module maintainers [drupalsupport@xecurify.com](mailto:drupalsupport@xecurify.com)
- Professional Drupal services
- Security consulting 