<?php

namespace Drupal\security_login_secure\Controller;

use Drupal\security_login_secure\website_security_error_403_page;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\security_login_secure\MiniorangeWebsiteSecurityConstants;

/**
 * Provides route responses for the website_security module.
 */
class security_login_secureController
{
    /**
     * This function is used to get the timestamp value
     */
    public function get_ns_timestamp()
    {
        $url = MiniorangeWebsiteSecurityConstants::XECURIFY_API_URL . '/rest/mobile/get-timestamp';
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_ENCODING, "");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_AUTOREFERER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); // required for https urls
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        $content = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Error in sending curl Request';
            exit();
        }

        curl_close($ch);

        if (empty($content)) {
            $currentTimeInMillis = round(microtime(true) * 1000);
            $currentTimeInMillis = number_format($currentTimeInMillis, 0, '', '');
        }

        return empty($content) ? $currentTimeInMillis : $content;
    }

    /**
     * Callback function for any kind of error occured in module
     */
    public function website_security_error()
    {
        website_security_error_403_page::error_page();
        return new Response();
    }
}
