<?php

namespace Drupal\security_login_secure\Form\Section;

use Drupal\Core\Form\FormStateInterface;
use Drupal\security_login_secure\Utilities;
use Drupal\security_login_secure\Form\WebsiteSecurityIPBlocking;
use Drupal\security_login_secure\MiniorangeWebsiteSecurityConstants;

/**
 * Form handler for Advanced blocking settings.
 */
class AdvancedBlockingForm extends WebsiteSecurityIPBlocking
{

    /**
     * {@inheritdoc}
     */
    public function build_advanced_blocking_form(array &$form, FormStateInterface $form_state)
    {
        global $base_url;
        $info_icon_url = Utilities::get_info_icon();
        $disabled = TRUE;

        $form['website_security_advanced_blocking'] = [
            '#type' => 'details',
            '#group' => 'information',
            '#title' => $this->t('Advanced Blocking'),
        ];

        $form['website_security_advanced_blocking']['website_security_add_block_ip_range'] = [
            '#type' => 'textfield',
            '#title' => $this->t('IP Range <a href=":premium_url">[Premium]</a><div class="ns_tooltip"><img src=":info_icon_url" alt="info icon" height="20px" width="15px"></div><div class="ns_tooltiptext">This feature allows you to block a complete IP range from accessing the Drupal site.</div>', [':info_icon_url' => $info_icon_url, ':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#attributes' => array('placeholder' => 'For eg. a.b.c.d-a.b.c.e;a.b.c.d-a.b.c.e'),
            '#description' => $this->t('<b>Note: </b>Provide dash(-) in between the IP range that you want to block and if you want to block multiple IP range then separate them using semicolon(;).'),
            '#disabled' => $disabled,
        ];
    }
}
