<?php

namespace Drupal\security_login_secure\Form\Section;

use Drupal\Core\Form\FormStateInterface;
use Drupal\security_login_secure\Utilities;
use Drupal\security_login_secure\Form\WebsiteSecurityIPBlocking;
use Drupal\security_login_secure\MiniorangeWebsiteSecurityConstants;

/**
 * Form handler for Advanced blocking settings.
 */
class BackupConfigurationForm extends WebsiteSecurityIPBlocking
{
    /**
     * {@inheritdoc}
     */
    public function build_backup_configuration_form(array &$form, FormStateInterface $form_state)
    {
        global $base_url;
        $disabled = TRUE;

        $form['backup_conf_settings'] = [
            '#type' => 'details',
            '#group' => 'information',
            '#title' => $this->t('Backup Database and Files'),
        ];

        $form['backup_conf_settings']['backup_enabled'] = [
            '#type' => 'checkbox',
            '#title' => $this->t('<b>Enable Backup<a href=":premium_url">[Premium]</a></b>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#description' => $this->t('Enable automatic backups of your database and files.'),
            '#disabled' => $disabled
        ];

        $form['backup_conf_settings']['backup_type'] = [
            '#type' => 'select',
            '#title' => $this->t('Backup Type Backup<a href=":premium_url">[Premium]</a>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#options' => [
                'database' => $this->t('Database'),
                'files' => $this->t('File'),
                'database_files' => $this->t('Both'),
            ],
            '#description' => $this->t('Select the type of backup to perform.'),
            '#disabled' => $disabled,
            '#attributes' => [
                'class' => ['form-select'],
            ],
        ];

        $form['backup_conf_settings']['backup_frequency'] = [
            '#type' => 'select',
            '#title' => $this->t('Backup Frequency<a href=":premium_url">[Premium]</a>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#options' => [
                'daily' => $this->t('Daily'),
                'weekly' => $this->t('Weekly'),
                'monthly' => $this->t('Monthly'),
            ],
            '#description' => $this->t('Select how often backups should be created.'),
            '#disabled' => $disabled,
        ];

        $form['backup_conf_settings']['backup_retention_period'] = [
            '#type' => 'textfield',
            '#title' => $this->t('Backup Retention Period (days) <a href=":premium_url">[Premium]</a>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#description' => $this->t('Number of days to keep backups before they are automatically deleted.'),
            '#disabled' => $disabled,
            '#default_value' => 30, // Default to 30 days
            '#size' => 5,
            '#maxlength' => 5,
            '#required' => TRUE,
        ];

        $form['backup_conf_settings']['backup_storage_location'] = [
            '#type' => 'textfield',
            '#title' => $this->t('Backup Storage Location<a href=":premium_url">[Premium]</a>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#description' => $this->t('Specify the directory where backups will be stored. Ensure it is writable by the web server.'),
            '#disabled' => $disabled,
            '#default_value' => '/path/to/backup/directory', // Default path
        ];

        $form['backup_conf_settings']['backup_notification_email'] = [
            '#type' => 'textfield',
            '#title' => $this->t('Notification Email <a href=":premium_url">[Premium]</a>', [':premium_url' => $base_url . MiniorangeWebsiteSecurityConstants::LICENSING_TAB_URL]),
            '#description' => $this->t('Email address to receive notifications about backup status.'),
            '#disabled' => $disabled,
            '#default_value' => '', // Default empty
        ];
    }
}
